<?php

namespace App\Http\Resources;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/

use App\Http\Helpers\HelperApp;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Facades\Log;

class TestGroupResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {




        return [
            "id" => (int) $this->id ,
            "patient"=>new PatientResource($this->patient),
            "doctor_name"=>$this->doctor->name,
            "step"=>HelperApp::get_step_data_resource($this),
            "is_complete"=>$this->check_complete($this),
            "date"=>$this->date,
            "created_at"=>$this->created_at,
            "type"=>$this->type_test_group?->name

        ];
    }


    private function check_complete($_this){
        $step =   request()->route('step');

        if($step == "step_4"){
            return $step == "step_4" && $_this->step_4_complete ? true : false;
        }else{
            return  $_this->$step ? true : false;
        }

    }



}
