<?php

namespace App\Http\Resources\TestGroup;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/

use App\Http\Resources\PatientFileResource;
use App\Http\Resources\TestGroupResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class Step3Resource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {

        $data = parent::toArray($request);
        $data['attachments']=  PatientFileResource::collection($this->attachments);
        $data['by_emb']=new DoctorResource($this->user);
        $data['analysis']= new TestGroupResource($this->analysis_patient);

        unset($data["analysis_patient_id"] , $data["user_id"] , $data["updated_at"]);
        return $data;


    }
}
