<?php

namespace App\Http\Resources;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class TaskResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $data =  parent::toArray($request);
        $data['status_translate']=$data['status'] == "created" ? __("messages.Not finished yet") : __("messages.Done");
        $data['to_user']=[
            "id"=>$this->to_user_id,
            "name"=>$this->to_user->name,

        ];
        $data['files_task']=TaskFileResource::collection($this->files_task);
        $data['files_report']=TaskFileResource::collection($this->files_report);
        unset($data['created_at'] , $data['updated_at'] , $data['created_by_id'] , $data['to_user_id']) ;
        return $data;


    }
}
