<?php

namespace App\Http\Resources;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ProtocolResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $data =  parent::toArray($request);
        unset($data['created_at'] , $data['updated_at']);
        $data['male_factors']= $this->male_factors->pluck('male_factor')->toArray();

        $data['ovarian_stimulation'] = ProtocolMedicationsOvarianStimulationResource::collection($this->medications_ovarian_stimulation);
        $data['ovarian_stimulation_ids'] = $this->medications_ovarian_stimulation->pluck('medication_id')->toArray();


        $data['ovulation_trigger'] = ProtocolMedicationsOvulationTriggerResource ::collection($this->medications_ovulation_trigger);
        $data['ovulation_trigger_ids'] = $this->medications_ovulation_trigger->pluck('medication_id')->toArray();

        $data['files_ultrasound'] = ProtocolFileResource::collection($this->files_ultrasound);
        $data['files_laparoscopy'] = ProtocolFileResource::collection($this->files_laparoscopy);
        $data['files_hysteroscopy'] = ProtocolFileResource::collection($this->files_hysteroscopy);



        return $data;
    }
}
