<?php

namespace App\Http\Resources;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ProductResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id'=>(int) $this->id,
            'name'=>$this->name,
            'image'=>asset($this->main_image->image),
            'price'=>number_format($this->price,2),
            'old_price'=>$this->old_price ? number_format($this->old_price,2) : null,
            'short_description'=>$this->short_description,
            'details'=>$this->details,

        ];
    }
}
