<?php

namespace App\Http\Resources;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class PostResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => (int) $this->id,
            'title' => $this->title,
            'title_slug' => $this->slug,
            'page_title' => config('app.name') . ' - ' . $this->title,
            'content' => $this->content,
            'tags' => TagResource::collection($this->tags),
            'created_at' => $this->created_at_format,
        ];
    }
}
