<?php

namespace App\Http\Resources;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class PgdResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            "id" => $this->id,
            "analysis_patient_id"=>$this->analysis_patient_id,
            "sample_date" => $this->sample_date,
            "sample_date_day" => $this->sample_date_day,
            "report_date" => $this->report_date,
            "report_date_day" => $this->report_date_day,
            "patient" => [
                "id" => $this->patient_id,
                "name" => $this->patient->name,
                "age" => $this->patient->age,
            ],
            "embyro" => PgdEmbyroResource::collection($this->attachments),
        ];
    }
}
