<?php

namespace App\Http\Resources;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/

use App\Models\AnalysisPatient;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class PatientResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {

        return [
            "id"=>$this->id,
            "gender"=>$this->gender,
            "name"=>$this->name,
            "age"=>$this->age,
            "occupation"=>$this->occupation,
            "height"=>$this->height,
            "mobile"=>$this->mobile,
            "place_of_residence"=>$this->place_of_residence,
            "id_number"=>$this->id_number,
            "medical_file_number"=>$this->medical_file_number,
            "date_of_visit"=>$this->date_of_visit,
            "medical_history"=>$this->medical_history,
            "other_name"=>$this->other_name,
            "other_age"=>$this->other_age,
            "other_occupation"=>$this->other_occupation,
            "other_height"=>$this->other_height,
            "other_mobile"=>$this->other_mobile,
            "other_place_of_residence"=>$this->other_place_of_residence,
            "other_id_number"=>$this->other_id_number,
            "other_medical_file_number"=>$this->other_medical_file_number,
            "other_date_of_visit"=>$this->other_date_of_visit,
            "other_medical_history"=>$this->other_medical_history,
            "created_at"=>$this->created_at,
            "pregenant_status"=>$this->pregenant_status ? true : false,
            "date_marriage"=>$this->date_marriage,
            "files"=>PatientFileResource::collection($this->files) ,
            "other_files"=>PatientFileResource::collection($this->other_files) ,
            "last_analysis"=>$this->last_analysis ? new AnalysisPatientResource($this->last_analysis) : null,
        ];
    }
}
