<?php

namespace App\Http\Resources;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class GeneticLabResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $data =  parent::toArray($request);
        $day_name = config('days.ar.'.$this->biopsy_day);
        if(app()->getLocale() != "ar"){
            $day_name = config('days.en.'.$this->biopsy_day);
        }
        $data['biopsy_day'] = $day_name;
        $data['biopsy_day_number'] =(int) $this->biopsy_day;
        unset($data['updated_at'] , $data['user_id']  , $data['patient_id']);
        $data['patient'] =[
            "id"=>$this->patient->id,
            "name"=>$this->patient->name,
            "other_name"=>$this->patient->other_name,
            "gender"=>$this->patient->gender,
            "medical_file_number"=>$this->patient->medical_file_number,
            "other_medical_file_number"=>$this->patient->other_medical_file_number



        ];
        $data['user'] =[
            "id"=>$this->user->id,
            "name"=>$this->user->name,
        ];

        $data['reports_files'] = GeneticLabReportResource::collection($this->reports_files);
        return $data;
    }
}
