<?php

namespace App\Http\Resources;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class CryopreservationResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        if($this->patient->gender == "male"){
            $male_name = $this->patient->name;
            $female_name = $this->patient->other_name;
        }else{
            $male_name = $this->patient->other_name;
            $female_name = $this->patient->name;
        }


        $day_name = config('days.ar.'.$this->day);
        if(app()->getLocale() != "ar"){
            $day_name = config('days.en.'.$this->day);
        }


        return [
            "patient_id"=>$this->patient->id,
            "type"=>$this->type,
            "wife_name"=>$female_name,
            "husband_name"=>$male_name,
            "date"=>$this->date,
            "oocyte_or_embryo"=>$this->oocyte_or_embryo,
            "number_oocyte_or_embryo"=>$this->number_oocyte_or_embryo,
            "day"=>$this->day,
            "day_translate"=>$day_name,
            "number_straw_or_straw_thawed"=>$this->number_straw_or_straw_thawed,
            "number_straw_remaining"=>$this->number_straw_remaining,
            "degree"=>$this->degree,
            "report"=>$this->report,
            "location_tank"=>$this->location_tank,
            "location_canisters"=>$this->location_canisters,
            "location_cryocane"=>$this->location_cryocane,
            "color_of_straw"=>$this->color_of_straw,
            "media"=>$this->media,
            "count"=>$this->count,
            "frozen_sample_type"=>$this->frozen_sample_type,
            "abnormal_form"=>$this->abnormal_form,
            "did_freezing"=>$this->did_freezing,
            "total_motility_progressive"=>$this->total_motility_progressive,
            "total_motility_non_progressive"=>$this->total_motility_non_progressive,
            "total_motility_immotile"=>$this->total_motility_immotile,
        ];
    }
}
