<?php

namespace App\Http\Resources;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ChatResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $unread_messages  =  false;
        if(auth('api')->id() == $this->user_1 && $this->is_not_open_all_user_1 ) {
            $unread_messages  =  true;
        }elseif(auth('api')->id() == $this->user_2 && $this->is_not_open_all_user_2){
            $unread_messages  =  true;
        }
        $response=  [
            "id" => (int) $this->id,
            "user" =>new  UserChatResource($this->user),
            "created_at" => $this->created_at,
            "last_message" => new MessageChatResource($this->last_message),
            "unread_messages"=>$unread_messages
        ];

        return $response;



    }
}
