<?php

namespace App\Http\Resources;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/

use App\Http\Helpers\HelperApp;
use App\Http\Helpers\HelperOrder;
use App\Http\Helpers\HelperSetting;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class CartResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {


        return [
            "id"=>(int) $this->id,
            "count"=>(int) $this->items->sum('qty'),
            "sub_total"=> floatval($this->sub_total),
            "tax_percent"=>floatval(HelperOrder::get_tax()),
            "items"=>CartItemResource::collection($this->items)
        ];


    }
}
