<?php

namespace App\Http\Resources;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class AndrologyResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            "analysis_patient_id" => $this->id,
            "analysis" => [
                "name" => $this->general_analysis->name,
                "type" => $this->general_analysis->type,
                "id" => $this->general_analysis->id,
            ],
            "analysis_data" => $this->get_data($this->general_analysis->type, $this),
            "patient" => new PatientResource($this->patient),



        ];
    }


    private function get_data($type, $_this)
    {
        $data = null;
        if ($type == "iui" && $_this->iui) {
            $data = $_this->iui;
        } elseif ($type == "fna" && $_this->fna) {

            $data = $_this->fna;
        } elseif ($type == "sfa" && $_this->sfa) {

            $data = $_this->sfa;
        } elseif ($type == 'pgd' && $_this->pgd) {

            $data = $_this->pgd;
        }

        if ($data) {
            return new AndrologyDataResource($data);
        } else {
            return null;
        }
    }
}
