<?php

namespace App\Http\Resources;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class AnalysisPatientResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {


        $report_vars = [];
        if($this->report){
            foreach($this->report->variables as $var){
                $report_vars[$var->variable_id]=$var->value;
            }
        }


        $variables=[];


        if($this->general_analysis?->variables){
            foreach($this->general_analysis->variables as $var){
                $variables[]=[
                    "id"=>$var->id,
                    "name"=>$var->name,
                    "value"=>isset($report_vars[$var->id]) ? $report_vars[$var->id] : null,
                    "default_value"=>$var->default_value
                ];
            }
        }


       // $variables = (object) $variables;



        if(!$this->is_sample_received){
            $status = "not_start";
        }else{
            if($this->report){
                $status = "complete";
            }else{
                $status = "underway";
            }
        }


        return [
            "id" => (int) $this->id ,
            "patient"=>[
                "id"=>$this->patient->id,
                "name"=>$this->patient->name,
                "age"=>$this->patient->age,
                "other_name"=>$this->patient->other_name,
                "gender"=>$this->patient->gender,
                "medical_file_number"=>$this->patient->medical_file_number,
                "other_medical_file_number"=>$this->patient->other_medical_file_number
            ],
            "doctor_name"=>$this->doctor->name,
            "status"=> $status,
            "created_at"=>$this->created_at,
            "variables"=>$variables,
            "type"=>$this->type,
            "report"=>$this->report ? new ReportGeneralAnalysisResource($this->report) : null,
            "general_analysis_name"=>$this->general_analysis?->name

        ];
    }
}
