<?php

namespace App\Http\Requests;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use App\Http\Helpers\HelperSetting;
use Illuminate\Foundation\Http\FormRequest;

class StaticSFAAnalysisRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */

    /*
    public function authorize(): bool
    {
        return false;
    }*/

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        $max =  HelperSetting::get_value('files_size_max_file_image') * 1024;
        return [

            'analysis_patient_id' => 'required|integer|exists:analysis_patients,id',
            'examination_time' => 'nullable|date_format:H:i',
            'collection_time' => 'nullable|date_format:H:i',
            'abstinence_days' => 'nullable|integer',
            'evaluation' => 'nullable|in:good,bad,excellent',
            'concentration' => 'nullable|string|max:255',
            'progressive' => 'nullable|numeric',
            'non-progressive' => 'nullable|string|max:255',
            'abnormal_form' => 'nullable|string|max:255',
            'ivf_for_dna_fragmentation' => 'nullable|boolean',
            'ivf_for_percent' => 'nullable|numeric',
            'ivf_for_note' => 'nullable|string',
            'ivf_for_fit_icsi' => 'nullable|boolean',
            'ivf_for_fit_iui' => 'nullable|boolean',
            'ivf_for_fit_pgd' => 'nullable|boolean',
            'ivf_for_fit_iui_xy' => 'nullable|boolean',
            'note' => 'nullable|string',
            'volume' => 'nullable|string|max:255',
            'color' => 'nullable|string|max:255',
            'viscosity' => 'nullable|string|max:255',
            'liquefaction' => 'nullable|string|max:255',
            'reaction' => 'nullable|string|max:255',
            'total_sperm_count' => 'nullable|string|max:255',
            'sperm_concentration' => 'nullable|string|max:255',
            'progressive_motility' => 'nullable|string|max:255',
            'non_progressive_motility' => 'nullable|string|max:255',
            'total_motility' => 'nullable|string|max:255',
            'immotile_sperm' => 'nullable|string|max:255',
            'sperm_morphology' => 'nullable|string|max:255',
            'round_cells' => 'nullable|string|max:255',
            'agglutination' => 'nullable|string|max:255',
            "attachments" => "nullable|array|max:5",
            "attachments.*" => "nullable|mimes:webm,mkv,flv,mp4,jpg,jpeg,png,pdf,doc,docs|max:" . $max,

        ];
    }


    public function messages(): array
    {
        $max = HelperSetting::get_value('files_size_max_file_image') * 1024;

        return [
            // رسائل analysis_patient_id
            'analysis_patient_id.required' => __('validation.The analysis patient ID field is required'),
            'analysis_patient_id.integer' => __('validation.The analysis patient ID must be an integer'),
            'analysis_patient_id.exists' => __('validation.The selected analysis patient ID is invalid'),

            // رسائل examination_time
            'examination_time.date_format' => __('validation.The examination time must be in the format H:i'),

            // رسائل collection_time
            'collection_time.date_format' => __('validation.The collection time must be in the format H:i'),

            // رسائل abstinence_days
            'abstinence_days.integer' => __('validation.The abstinence days must be an integer'),

            // رسائل evaluation
            'evaluation.in' => __('validation.The evaluation must be one of: good, bad, excellent'),

            // رسائل concentration
            'concentration.string' => __('validation.The concentration must be a string'),
            'concentration.max' => __('validation.The concentration may not be greater than :max characters'),

            // رسائل progressive
            'progressive.numeric' => __('validation.The progressive must be a number'),

            // رسائل non-progressive
            'non-progressive.string' => __('validation.The non-progressive must be a string'),
            'non-progressive.max' => __('validation.The non-progressive may not be greater than :max characters'),

            // رسائل abnormal_form
            'abnormal_form.string' => __('validation.The abnormal form must be a string'),
            'abnormal_form.max' => __('validation.The abnormal form may not be greater than :max characters'),

            // رسائل ivf_for_dna_fragmentation
            'ivf_for_dna_fragmentation.boolean' => __('validation.The IVF for DNA fragmentation field must be true or false'),

            // رسائل ivf_for_percent
            'ivf_for_percent.numeric' => __('validation.The IVF for percent must be a number'),

            // رسائل ivf_for_note
            'ivf_for_note.string' => __('validation.The IVF for note must be a string'),

            // رسائل ivf_for_fit_icsi
            'ivf_for_fit_icsi.boolean' => __('validation.The IVF for fit ICSI field must be true or false'),

            // رسائل ivf_for_fit_iui
            'ivf_for_fit_iui.boolean' => __('validation.The IVF for fit IUI field must be true or false'),

            // رسائل ivf_for_fit_pgd
            'ivf_for_fit_pgd.boolean' => __('validation.The IVF for fit PGD field must be true or false'),

            // رسائل ivf_for_fit_iui_xy
            'ivf_for_fit_iui_xy.boolean' => __('validation.The IVF for fit IUI XY field must be true or false'),

            // رسائل note
            'note.string' => __('validation.The note must be a string'),

            // رسائل volume
            'volume.string' => __('validation.The volume must be a string'),
            'volume.max' => __('validation.The volume may not be greater than :max characters'),

            // رسائل color
            'color.string' => __('validation.The color must be a string'),
            'color.max' => __('validation.The color may not be greater than :max characters'),

            // رسائل viscosity
            'viscosity.string' => __('validation.The viscosity must be a string'),
            'viscosity.max' => __('validation.The viscosity may not be greater than :max characters'),

            // رسائل liquefaction
            'liquefaction.string' => __('validation.The liquefaction must be a string'),
            'liquefaction.max' => __('validation.The liquefaction may not be greater than :max characters'),

            // رسائل reaction
            'reaction.string' => __('validation.The reaction must be a string'),
            'reaction.max' => __('validation.The reaction may not be greater than :max characters'),

            // رسائل total_sperm_count
            'total_sperm_count.string' => __('validation.The total sperm count must be a string'),
            'total_sperm_count.max' => __('validation.The total sperm count may not be greater than :max characters'),

            // رسائل sperm_concentration
            'sperm_concentration.string' => __('validation.The sperm concentration must be a string'),
            'sperm_concentration.max' => __('validation.The sperm concentration may not be greater than :max characters'),

            // رسائل progressive_motility
            'progressive_motility.string' => __('validation.The progressive motility must be a string'),
            'progressive_motility.max' => __('validation.The progressive motility may not be greater than :max characters'),

            // رسائل non_progressive_motility
            'non_progressive_motility.string' => __('validation.The non progressive motility must be a string'),
            'non_progressive_motility.max' => __('validation.The non progressive motility may not be greater than :max characters'),

            // رسائل total_motility
            'total_motility.string' => __('validation.The total motility must be a string'),
            'total_motility.max' => __('validation.The total motility may not be greater than :max characters'),

            // رسائل immotile_sperm
            'immotile_sperm.string' => __('validation.The immotile sperm must be a string'),
            'immotile_sperm.max' => __('validation.The immotile sperm may not be greater than :max characters'),

            // رسائل sperm_morphology
            'sperm_morphology.string' => __('validation.The sperm morphology must be a string'),
            'sperm_morphology.max' => __('validation.The sperm morphology may not be greater than :max characters'),

            // رسائل round_cells
            'round_cells.string' => __('validation.The round cells must be a string'),
            'round_cells.max' => __('validation.The round cells may not be greater than :max characters'),

            // رسائل agglutination
            'agglutination.string' => __('validation.The agglutination must be a string'),
            'agglutination.max' => __('validation.The agglutination may not be greater than :max characters'),

            // رسائل attachments
            'attachments.array' => __('validation.The attachments must be an array'),
            'attachments.max' => __('validation.The attachments may not have more than :max items'),

            // رسائل attachments.*
            'attachments.*.mimes' => __('validation.Each attachment must be of type: webm, mkv, flv, mp4, jpg, jpeg, png, pdf, doc, docs'),
            'attachments.*.max' => __('validation.Each attachment may not be greater than :max kilobytes'),
        ];
    }
}
