<?php

namespace App\Http\Requests;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use App\Http\Helpers\HelperSetting;
use Illuminate\Foundation\Http\FormRequest;

class StaticIUIAnalysisRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */

    /*
    public function authorize(): bool
    {
        return false;
    }*/

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        $max =  HelperSetting::get_value('files_size_max_file_image') * 1024;
        return [

            "analysis_patient_id" => "required|integer|exists:analysis_patients,id",
            "examination_time" => "nullable|date_format:H:i",
            "collection_time" => "nullable|date_format:H:i",
            "abstinence_days" => "nullable|integer",
            "evaluation" => "nullable|string|in:good,bad,excellent",
            'volume' => 'nullable|string|max:255',
            'color' => 'nullable|string|max:255',
            'viscosity' => 'nullable|string|max:255',
            'liquefaction' => 'nullable|string|max:255',
            'reaction' => 'nullable|string|max:255',
            'total_sperm_count_before' => 'nullable|string|max:255',
            'total_sperm_count_after' => 'nullable|string|max:255',
            'sperm_concentration_before' => 'nullable|string|max:255',
            'sperm_concentration_after' => 'nullable|string|max:255',
            'progressive_motility_before' => 'nullable|string|max:255',
            'progressive_motility_after' => 'nullable|string|max:255',
            'non_progressive_motility_before' => 'nullable|string|max:255',
            'non_progressive_motility_after' => 'nullable|string|max:255',
            'total_motility_before' => 'nullable|string|max:255',
            'total_motility_after' => 'nullable|string|max:255',
            'immotile_sperm_before' => 'nullable|string|max:255',
            'immotile_sperm_after' => 'nullable|string|max:255',
            'sperm_morphology_before' => 'nullable|string|max:255',
            'sperm_morphology_after' => 'nullable|string|max:255',
            'round_cells_before' => 'nullable|string|max:255',
            'round_cells_after' => 'nullable|string|max:255',
            'agglutination_before' => 'nullable|string|max:255',
            'agglutination_after' => 'nullable|string|max:255',
            'note' => "nullable|string|max:100000",
            "attachments" => "nullable|array|max:5",
            "attachments.*" => "nullable|mimes:webm,mkv,flv,mp4,jpg,jpeg,png,pdf,doc,docs|max:" . $max,
        ];
    }


    public function messages(): array
    {
        $max = HelperSetting::get_value('files_size_max_file_image') * 1024;

        return [
            // رسائل analysis_patient_id
            'analysis_patient_id.required' => __('validation.The analysis patient ID field is required'),
            'analysis_patient_id.integer' => __('validation.The analysis patient ID must be an integer'),
            'analysis_patient_id.exists' => __('validation.The selected analysis patient ID is invalid'),

            // رسائل examination_time
            'examination_time.date_format' => __('validation.The examination time must be in the format H:i'),

            // رسائل collection_time
            'collection_time.date_format' => __('validation.The collection time must be in the format H:i'),

            // رسائل abstinence_days
            'abstinence_days.integer' => __('validation.The abstinence days must be an integer'),

            // رسائل evaluation
            'evaluation.string' => __('validation.The evaluation must be a string'),
            'evaluation.in' => __('validation.The evaluation must be one of: good, bad, excellent'),

            // رسائل volume, color, viscosity, liquefaction, reaction
            'volume.string' => __('validation.The volume must be a string'),
            'volume.max' => __('validation.The volume may not be greater than :max characters'),
            'color.string' => __('validation.The color must be a string'),
            'color.max' => __('validation.The color may not be greater than :max characters'),
            'viscosity.string' => __('validation.The viscosity must be a string'),
            'viscosity.max' => __('validation.The viscosity may not be greater than :max characters'),
            'liquefaction.string' => __('validation.The liquefaction must be a string'),
            'liquefaction.max' => __('validation.The liquefaction may not be greater than :max characters'),
            'reaction.string' => __('validation.The reaction must be a string'),
            'reaction.max' => __('validation.The reaction may not be greater than :max characters'),

            // رسائل total_sperm_count_before و total_sperm_count_after
            'total_sperm_count_before.string' => __('validation.The total sperm count before must be a string'),
            'total_sperm_count_before.max' => __('validation.The total sperm count before may not be greater than :max characters'),
            'total_sperm_count_after.string' => __('validation.The total sperm count after must be a string'),
            'total_sperm_count_after.max' => __('validation.The total sperm count after may not be greater than :max characters'),

            // رسائل sperm_concentration_before و sperm_concentration_after
            'sperm_concentration_before.string' => __('validation.The sperm concentration before must be a string'),
            'sperm_concentration_before.max' => __('validation.The sperm concentration before may not be greater than :max characters'),
            'sperm_concentration_after.string' => __('validation.The sperm concentration after must be a string'),
            'sperm_concentration_after.max' => __('validation.The sperm concentration after may not be greater than :max characters'),

            // رسائل progressive_motility_before و progressive_motility_after
            'progressive_motility_before.string' => __('validation.The progressive motility before must be a string'),
            'progressive_motility_before.max' => __('validation.The progressive motility before may not be greater than :max characters'),
            'progressive_motility_after.string' => __('validation.The progressive motility after must be a string'),
            'progressive_motility_after.max' => __('validation.The progressive motility after may not be greater than :max characters'),

            // رسائل non_progressive_motility_before و non_progressive_motility_after
            'non_progressive_motility_before.string' => __('validation.The non progressive motility before must be a string'),
            'non_progressive_motility_before.max' => __('validation.The non progressive motility before may not be greater than :max characters'),
            'non_progressive_motility_after.string' => __('validation.The non progressive motility after must be a string'),
            'non_progressive_motility_after.max' => __('validation.The non progressive motility after may not be greater than :max characters'),

            // رسائل total_motility_before و total_motility_after
            'total_motility_before.string' => __('validation.The total motility before must be a string'),
            'total_motility_before.max' => __('validation.The total motility before may not be greater than :max characters'),
            'total_motility_after.string' => __('validation.The total motility after must be a string'),
            'total_motility_after.max' => __('validation.The total motility after may not be greater than :max characters'),

            // رسائل immotile_sperm_before و immotile_sperm_after
            'immotile_sperm_before.string' => __('validation.The immotile sperm before must be a string'),
            'immotile_sperm_before.max' => __('validation.The immotile sperm before may not be greater than :max characters'),
            'immotile_sperm_after.string' => __('validation.The immotile sperm after must be a string'),
            'immotile_sperm_after.max' => __('validation.The immotile sperm after may not be greater than :max characters'),

            // رسائل sperm_morphology_before و sperm_morphology_after
            'sperm_morphology_before.string' => __('validation.The sperm morphology before must be a string'),
            'sperm_morphology_before.max' => __('validation.The sperm morphology before may not be greater than :max characters'),
            'sperm_morphology_after.string' => __('validation.The sperm morphology after must be a string'),
            'sperm_morphology_after.max' => __('validation.The sperm morphology after may not be greater than :max characters'),

            // رسائل round_cells_before و round_cells_after
            'round_cells_before.string' => __('validation.The round cells before must be a string'),
            'round_cells_before.max' => __('validation.The round cells before may not be greater than :max characters'),
            'round_cells_after.string' => __('validation.The round cells after must be a string'),
            'round_cells_after.max' => __('validation.The round cells after may not be greater than :max characters'),

            // رسائل agglutination_before و agglutination_after
            'agglutination_before.string' => __('validation.The agglutination before must be a string'),
            'agglutination_before.max' => __('validation.The agglutination before may not be greater than :max characters'),
            'agglutination_after.string' => __('validation.The agglutination after must be a string'),
            'agglutination_after.max' => __('validation.The agglutination after may not be greater than :max characters'),

            // رسائل note
            'note.string' => __('validation.The note must be a string'),
            'note.max' => __('validation.The note may not be greater than :max characters'),

            // رسائل attachments
            'attachments.array' => __('validation.The attachments must be an array'),
            'attachments.max' => __('validation.The attachments may not have more than :max items'),

            // رسائل attachments.*
            'attachments.*.mimes' => __('validation.Each attachment must be of type: webm, mkv, flv, mp4, jpg, jpeg, png, pdf, doc, docs'),
            'attachments.*.max' => __('validation.Each attachment may not be greater than :max kilobytes'),
        ];
    }
}
