<?php

namespace App\Http\Requests;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use App\Http\Helpers\HelperSetting;
use Illuminate\Foundation\Http\FormRequest;

class StaticFNAAnalysisRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */

    /*
    public function authorize(): bool
    {
        return false;
    }*/

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        $max =  HelperSetting::get_value('files_size_max_file_image') * 1024;
        return [
            "analysis_patient_id" => "required|integer|exists:analysis_patients,id",
            'date' => 'required|date_format:Y-m-d',
            'note' => 'nullable|string',
            'fna' => 'nullable|boolean',
            'tesa' => 'nullable|boolean',
            'tese' => 'nullable|boolean',
            'sperm_concentration_left' => 'nullable|string|max:255',
            'sperm_concentration_right' => 'nullable|string|max:255',
            'progressive_motility_left' => 'nullable|string|max:255',
            'progressive_motility_right' => 'nullable|string|max:255',
            'non_progressive_motility_left' => 'nullable|string|max:255',
            'non_progressive_motility_right' => 'nullable|string|max:255',
            'total_motility_left' => 'nullable|string|max:255',
            'total_motility_right' => 'nullable|string|max:255',
            'immotile_sperm_left' => 'nullable|string|max:255',
            'immotile_sperm_right' => 'nullable|string|max:255',
            'sperm_morphology_left' => 'nullable|string|max:255',
            'sperm_morphology_right' => 'nullable|string|max:255',
            "attachments" => "nullable|array|max:5",
            "attachments.*" => "nullable|mimes:webm,mkv,flv,mp4,jpg,jpeg,png,pdf,doc,docs|max:" . $max,
        ];
    }

    public function messages(): array
    {
        $max = HelperSetting::get_value('files_size_max_file_image') * 1024;

        return [
            // رسائل analysis_patient_id
            'analysis_patient_id.required' => __('validation.The analysis patient ID field is required'),
            'analysis_patient_id.integer' => __('validation.The analysis patient ID must be an integer'),
            'analysis_patient_id.exists' => __('validation.The selected analysis patient ID is invalid'),

            // رسائل date
            'date.required' => __('validation.The date field is required'),
            'date.date_format' => __('validation.The date must be in the format Y-m-d'),

            // رسائل note
            'note.string' => __('validation.The note must be a string'),

            // رسائل fna, tesa, tese
            'fna.boolean' => __('validation.The FNA field must be true or false'),
            'tesa.boolean' => __('validation.The TESA field must be true or false'),
            'tese.boolean' => __('validation.The TESE field must be true or false'),

            // رسائل sperm_concentration_left و sperm_concentration_right
            'sperm_concentration_left.string' => __('validation.The sperm concentration left must be a string'),
            'sperm_concentration_left.max' => __('validation.The sperm concentration left may not be greater than :max characters'),
            'sperm_concentration_right.string' => __('validation.The sperm concentration right must be a string'),
            'sperm_concentration_right.max' => __('validation.The sperm concentration right may not be greater than :max characters'),

            // رسائل progressive_motility_left و progressive_motility_right
            'progressive_motility_left.string' => __('validation.The progressive motility left must be a string'),
            'progressive_motility_left.max' => __('validation.The progressive motility left may not be greater than :max characters'),
            'progressive_motility_right.string' => __('validation.The progressive motility right must be a string'),
            'progressive_motility_right.max' => __('validation.The progressive motility right may not be greater than :max characters'),

            // رسائل non_progressive_motility_left و non_progressive_motility_right
            'non_progressive_motility_left.string' => __('validation.The non progressive motility left must be a string'),
            'non_progressive_motility_left.max' => __('validation.The non progressive motility left may not be greater than :max characters'),
            'non_progressive_motility_right.string' => __('validation.The non progressive motility right must be a string'),
            'non_progressive_motility_right.max' => __('validation.The non progressive motility right may not be greater than :max characters'),

            // رسائل total_motility_left و total_motility_right
            'total_motility_left.string' => __('validation.The total motility left must be a string'),
            'total_motility_left.max' => __('validation.The total motility left may not be greater than :max characters'),
            'total_motility_right.string' => __('validation.The total motility right must be a string'),
            'total_motility_right.max' => __('validation.The total motility right may not be greater than :max characters'),

            // رسائل immotile_sperm_left و immotile_sperm_right
            'immotile_sperm_left.string' => __('validation.The immotile sperm left must be a string'),
            'immotile_sperm_left.max' => __('validation.The immotile sperm left may not be greater than :max characters'),
            'immotile_sperm_right.string' => __('validation.The immotile sperm right must be a string'),
            'immotile_sperm_right.max' => __('validation.The immotile sperm right may not be greater than :max characters'),

            // رسائل sperm_morphology_left و sperm_morphology_right
            'sperm_morphology_left.string' => __('validation.The sperm morphology left must be a string'),
            'sperm_morphology_left.max' => __('validation.The sperm morphology left may not be greater than :max characters'),
            'sperm_morphology_right.string' => __('validation.The sperm morphology right must be a string'),
            'sperm_morphology_right.max' => __('validation.The sperm morphology right may not be greater than :max characters'),

            // رسائل attachments
            'attachments.array' => __('validation.The attachments must be an array'),
            'attachments.max' => __('validation.The attachments may not have more than :max items'),

            // رسائل attachments.*
            'attachments.*.mimes' => __('validation.Each attachment must be of type: webm, mkv, flv, mp4, jpg, jpeg, png, pdf, doc, docs'),
            'attachments.*.max' => __('validation.Each attachment may not be greater than :max kilobytes'),
        ];
    }
}
