<?php

namespace App\Http\Requests\Api\TestGroup;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/

use App\Http\Helpers\HelperSetting;
use Illuminate\Foundation\Http\FormRequest;

class StepThreeRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */

    /*
    public function authorize(): bool
    {
        return false;
    }*/

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        $max =  HelperSetting::get_value('files_size_max_file_image') * 1024;
        return [
            "analysis_patient_id" => "required|integer|exists:analysis_patients,id,type,test_group",
            "number_oocyte_injected" => "required|integer",
            "time" => "required|date_format:H:i",
            "m_1" => "required|integer",
            "m_2" => "required|integer",
            "g_v" => "required|integer",
            "degeneration_rate_after_icsi" => "required|integer",
            "abnormal" => "required|integer",
            "option_giant" => "required|boolean",
            "option_smal" => "required|boolean",
            "option_oval" => "required|boolean",
            "option_irregular" => "required|boolean",
            "normal_shape_and_size" => "required|boolean", //  options new


            "option_large_polar_bodies" => "required|boolean",
            "option_fragmented_polar_bodies" => "required|boolean",
            "option_multi_polar_bodies" => "required|boolean",
            "normal_polar_bodies" => "required|boolean", //  options new
            "option_wide_space" => "required|boolean",
            "option_uneven_space" => "required|boolean",
            "normal_prvitilan_space" => "required|boolean", //  options new
            "normal_cytoplasm" => "required|boolean", //  options new
            "option_inclusions_in_the_space" => "required|boolean",
            "option_thin_zone" => "required|boolean",
            "option_thick_zona" => "required|boolean",
            "normal_zona" => "required|boolean", //  options new
            "option_hairy_brush_like" => "required|boolean",
            "option_empty_zona" => "required|boolean",
            "option_vacuolated" => "required|boolean",
            "option_dark" => "required|boolean",
            "option_granulation" => "required|boolean",
            "option_blebs" => "required|boolean",
            "option_refractile_bodies" => "required|boolean",
            "evaluation_oocyte" => "required|string|in:very_bad,bad,accepted,good",
            "evaluation_oocyte_report" => "required|string|max:100000",
            "sperm_source_ejaculate" => "required|boolean",
            "sperm_source_fns" => "required|boolean",
            "sperm_source_tese" => "required|boolean",
            "sperm_source_tesa" => "required|boolean",
            "sperm_source_frozen" => "required|boolean",
            "count" => "required|string",
            "motility" => "required|numeric|max:100",
            "abnormal_form" => "required|numeric|max:100",
            "evaluation_sperm" => "required|string|in:very_bad,bad,accepted,good",
            "evaluation_sperm_report" => "required|string|max:100000",
            "attachments" => "nullable|array|max:5",
            "attachments.*" => "required|mimes:webm,mkv,flv,mp4,jpg,jpeg,png,pdf,doc,docs|max:" . $max,
        ];
    }

    public function messages(): array
    {
        return [
            // analysis_patient_id
            'analysis_patient_id.required' => __('validation.The analysis patient ID field is required'),
            'analysis_patient_id.integer' => __('validation.The analysis patient ID must be an integer'),
            'analysis_patient_id.exists' => __('validation.The selected analysis patient ID is invalid'),

            // number_oocyte_injected
            'number_oocyte_injected.required' => __('validation.The number of injected oocytes field is required'),
            'number_oocyte_injected.integer' => __('validation.The number of injected oocytes must be an integer'),

            // time
            'time.required' => __('validation.The time field is required'),
            'time.date_format' => __('validation.The time must be in the format H:i'),

            // m_1
            'm_1.required' => __('validation.The M1 field is required'),
            'm_1.integer' => __('validation.The M1 must be an integer'),

            // m_2
            'm_2.required' => __('validation.The M2 field is required'),
            'm_2.integer' => __('validation.The M2 must be an integer'),

            // g_v
            'g_v.required' => __('validation.The GV field is required'),
            'g_v.integer' => __('validation.The GV must be an integer'),

            // degeneration_rate_after_icsi
            'degeneration_rate_after_icsi.required' => __('validation.The degeneration rate after ICSI field is required'),
            'degeneration_rate_after_icsi.integer' => __('validation.The degeneration rate after ICSI must be an integer'),

            // abnormal
            'abnormal.required' => __('validation.The abnormal field is required'),
            'abnormal.integer' => __('validation.The abnormal must be an integer'),

            // option_giant
            'option_giant.required' => __('validation.The giant option field is required'),
            'option_giant.boolean' => __('validation.The giant option must be a boolean'),

            // option_smal
            'option_smal.required' => __('validation.The small option field is required'),
            'option_smal.boolean' => __('validation.The small option must be a boolean'),

            // option_oval
            'option_oval.required' => __('validation.The oval option field is required'),
            'option_oval.boolean' => __('validation.The oval option must be a boolean'),

            // option_irregular
            'option_irregular.required' => __('validation.The irregular option field is required'),
            'option_irregular.boolean' => __('validation.The irregular option must be a boolean'),

            // normal_shape_and_size
            'normal_shape_and_size.required' => __('validation.The normal shape and size field is required'),
            'normal_shape_and_size.boolean' => __('validation.The normal shape and size must be a boolean'),

            // option_large_polar_bodies
            'option_large_polar_bodies.required' => __('validation.The large polar bodies option field is required'),
            'option_large_polar_bodies.boolean' => __('validation.The large polar bodies option must be a boolean'),

            // option_fragmented_polar_bodies
            'option_fragmented_polar_bodies.required' => __('validation.The fragmented polar bodies option field is required'),
            'option_fragmented_polar_bodies.boolean' => __('validation.The fragmented polar bodies option must be a boolean'),

            // option_multi_polar_bodies
            'option_multi_polar_bodies.required' => __('validation.The multi polar bodies option field is required'),
            'option_multi_polar_bodies.boolean' => __('validation.The multi polar bodies option must be a boolean'),

            // normal_polar_bodies
            'normal_polar_bodies.required' => __('validation.The normal polar bodies field is required'),
            'normal_polar_bodies.boolean' => __('validation.The normal polar bodies must be a boolean'),

            // option_wide_space
            'option_wide_space.required' => __('validation.The wide space option field is required'),
            'option_wide_space.boolean' => __('validation.The wide space option must be a boolean'),

            // option_uneven_space
            'option_uneven_space.required' => __('validation.The uneven space option field is required'),
            'option_uneven_space.boolean' => __('validation.The uneven space option must be a boolean'),

            // normal_prvitilan_space
            'normal_prvitilan_space.required' => __('validation.The normal perivitelline space field is required'),
            'normal_prvitilan_space.boolean' => __('validation.The normal perivitelline space must be a boolean'),

            // normal_cytoplasm
            'normal_cytoplasm.required' => __('validation.The normal cytoplasm field is required'),
            'normal_cytoplasm.boolean' => __('validation.The normal cytoplasm must be a boolean'),

            // option_inclusions_in_the_space
            'option_inclusions_in_the_space.required' => __('validation.The inclusions in the space option field is required'),
            'option_inclusions_in_the_space.boolean' => __('validation.The inclusions in the space option must be a boolean'),

            // option_thin_zone
            'option_thin_zone.required' => __('validation.The thin zona option field is required'),
            'option_thin_zone.boolean' => __('validation.The thin zona option must be a boolean'),

            // option_thick_zona
            'option_thick_zona.required' => __('validation.The thick zona option field is required'),
            'option_thick_zona.boolean' => __('validation.The thick zona option must be a boolean'),

            // normal_zona
            'normal_zona.required' => __('validation.The normal zona field is required'),
            'normal_zona.boolean' => __('validation.The normal zona must be a boolean'),

            // option_hairy_brush_like
            'option_hairy_brush_like.required' => __('validation.The hairy brush-like option field is required'),
            'option_hairy_brush_like.boolean' => __('validation.The hairy brush-like option must be a boolean'),

            // option_empty_zona
            'option_empty_zona.required' => __('validation.The empty zona option field is required'),
            'option_empty_zona.boolean' => __('validation.The empty zona option must be a boolean'),

            // option_vacuolated
            'option_vacuolated.required' => __('validation.The vacuolated option field is required'),
            'option_vacuolated.boolean' => __('validation.The vacuolated option must be a boolean'),

            // option_dark
            'option_dark.required' => __('validation.The dark option field is required'),
            'option_dark.boolean' => __('validation.The dark option must be a boolean'),

            // option_granulation
            'option_granulation.required' => __('validation.The granulation option field is required'),
            'option_granulation.boolean' => __('validation.The granulation option must be a boolean'),

            // option_blebs
            'option_blebs.required' => __('validation.The blebs option field is required'),
            'option_blebs.boolean' => __('validation.The blebs option must be a boolean'),

            // option_refractile_bodies
            'option_refractile_bodies.required' => __('validation.The refractile bodies option field is required'),
            'option_refractile_bodies.boolean' => __('validation.The refractile bodies option must be a boolean'),

            // evaluation_oocyte
            'evaluation_oocyte.required' => __('validation.The oocyte evaluation field is required'),
            'evaluation_oocyte.string' => __('validation.The oocyte evaluation must be a string'),
            'evaluation_oocyte.in' => __('validation.The oocyte evaluation must be one of the following: very bad, bad, accepted, good'),

            // evaluation_oocyte_report
            'evaluation_oocyte_report.required' => __('validation.The oocyte evaluation report field is required'),
            'evaluation_oocyte_report.string' => __('validation.The oocyte evaluation report must be a string'),
            'evaluation_oocyte_report.max' => __('validation.The oocyte evaluation report must not be greater than :max characters'),

            // sperm_source_ejaculate
            'sperm_source_ejaculate.required' => __('validation.The ejaculate sperm source field is required'),
            'sperm_source_ejaculate.boolean' => __('validation.The ejaculate sperm source must be a boolean'),

            // sperm_source_fns
            'sperm_source_fns.required' => __('validation.The FNS sperm source field is required'),
            'sperm_source_fns.boolean' => __('validation.The FNS sperm source must be a boolean'),

            // sperm_source_tese
            'sperm_source_tese.required' => __('validation.The TESE sperm source field is required'),
            'sperm_source_tese.boolean' => __('validation.The TESE sperm source must be a boolean'),

            // sperm_source_tesa
            'sperm_source_tesa.required' => __('validation.The TESA sperm source field is required'),
            'sperm_source_tesa.boolean' => __('validation.The TESA sperm source must be a boolean'),

            // sperm_source_frozen
            'sperm_source_frozen.required' => __('validation.The frozen sperm source field is required'),
            'sperm_source_frozen.boolean' => __('validation.The frozen sperm source must be a boolean'),

            // count
            'count.required' => __('validation.The count field is required'),
            'count.string' => __('validation.The count must be a string'),

            // motility
            'motility.required' => __('validation.The motility field is required'),
            'motility.numeric' => __('validation.The motility must be a number'),
            'motility.max' => __('validation.The motility must not be greater than :max'),

            // abnormal_form
            'abnormal_form.required' => __('validation.The abnormal form field is required'),
            'abnormal_form.numeric' => __('validation.The abnormal form must be a number'),
            'abnormal_form.max' => __('validation.The abnormal form must not be greater than :max'),

            // evaluation_sperm
            'evaluation_sperm.required' => __('validation.The sperm evaluation field is required'),
            'evaluation_sperm.string' => __('validation.The sperm evaluation must be a string'),
            'evaluation_sperm.in' => __('validation.The sperm evaluation must be one of the following: very bad, bad, accepted, good'),

            // evaluation_sperm_report
            'evaluation_sperm_report.required' => __('validation.The sperm evaluation report field is required'),
            'evaluation_sperm_report.string' => __('validation.The sperm evaluation report must be a string'),
            'evaluation_sperm_report.max' => __('validation.The sperm evaluation report must not be greater than :max characters'),

            // attachments
            'attachments.array' => __('validation.The attachments must be an array'),
            'attachments.max' => __('validation.The attachments must not have more than :max files'),
            'attachments.*.required' => __('validation.Each attachment file is required'),
            'attachments.*.mimes' => __('validation.Each attachment file must be of type: webm, mkv, flv, mp4, jpg, jpeg, png, pdf, doc, docs'),
            'attachments.*.max' => __('validation.Each attachment file must not be greater than :max kilobytes'),
        ];
    }
}
