<?php

namespace App\Http\Requests\Api\TestGroup;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use Illuminate\Foundation\Http\FormRequest;

class StepSevenRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */

    /*
    public function authorize(): bool
    {
        return false;
    }*/

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */

    public function rules(): array
    {
        return [
            "analysis_patient_id"=>"required|integer|exists:analysis_patients,id,type,test_group",
            "oocyte_or_embryo"=>"required|string|in:oocyte,embryo",
            "number_oocyte_or_embryo"=>"required|integer",
            "day"=>"required|integer|min:1|max:6",
            "number_straw_thawed"=>"required|integer",
            "number_straw_remaining"=>"required|integer",
            "degree"=>"required|string|max:100000",
            "report"=>"required|string|max:100000",
            "color_of_straw"=>"required|string|max:255",
            "media"=>"required|string|max:255",
            "pregnancy_status"=>"required|string|in:pregnant,not_pregnant,miscarriage,not_returned",

        ];
    }

    public function messages(): array
{
    return [
        // analysis_patient_id
        'analysis_patient_id.required' => __('validation.The analysis patient ID field is required'),
        'analysis_patient_id.integer' => __('validation.The analysis patient ID must be an integer'),
        'analysis_patient_id.exists' => __('validation.The selected analysis patient ID is invalid'),

        // oocyte_or_embryo
        'oocyte_or_embryo.required' => __('validation.The oocyte or embryo field is required'),
        'oocyte_or_embryo.string' => __('validation.The oocyte or embryo must be a string'),
        'oocyte_or_embryo.in' => __('validation.The oocyte or embryo must be either "oocyte" or "embryo"'),

        // number_oocyte_or_embryo
        'number_oocyte_or_embryo.required' => __('validation.The number of oocytes or embryos field is required'),
        'number_oocyte_or_embryo.integer' => __('validation.The number of oocytes or embryos must be an integer'),

        // day
        'day.required' => __('validation.The day field is required'),
        'day.integer' => __('validation.The day must be an integer'),
        'day.min' => __('validation.The day must be at least :min'),
        'day.max' => __('validation.The day must not be greater than :max'),

        // number_straw_thawed
        'number_straw_thawed.required' => __('validation.The number of straws thawed field is required'),
        'number_straw_thawed.integer' => __('validation.The number of straws thawed must be an integer'),

        // number_straw_remaining
        'number_straw_remaining.required' => __('validation.The number of straws remaining field is required'),
        'number_straw_remaining.integer' => __('validation.The number of straws remaining must be an integer'),

        // degree
        'degree.required' => __('validation.The degree field is required'),
        'degree.string' => __('validation.The degree must be a string'),
        'degree.max' => __('validation.The degree must not be greater than :max characters'),

        // report
        'report.required' => __('validation.The report field is required'),
        'report.string' => __('validation.The report must be a string'),
        'report.max' => __('validation.The report must not be greater than :max characters'),

        // color_of_straw
        'color_of_straw.required' => __('validation.The color of straw field is required'),
        'color_of_straw.string' => __('validation.The color of straw must be a string'),
        'color_of_straw.max' => __('validation.The color of straw must not be greater than :max characters'),

        // media
        'media.required' => __('validation.The media field is required'),
        'media.string' => __('validation.The media must be a string'),
        'media.max' => __('validation.The media must not be greater than :max characters'),

        // pregnancy_status
        'pregnancy_status.required' => __('validation.The pregnancy status field is required'),
        'pregnancy_status.string' => __('validation.The pregnancy status must be a string'),
        'pregnancy_status.in' => __('validation.The pregnancy status must be one of the following: pregnant, not pregnant, miscarriage, not returned'),
    ];
}
}
