<?php

namespace App\Http\Requests\Api\TestGroup;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use Illuminate\Foundation\Http\FormRequest;

class StepOneAndTwoRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */

    /*
    public function authorize(): bool
    {
        return false;
    }*/

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
            "analysis_patient_id"=>"required|integer|exists:analysis_patients,id,type,test_group",
            "number_oocyte"=>"required|integer",
            "time"=>"required|date_format:H:i",
            "report"=>"required|string|max:100000",
            "step"=>"required|integer|in:1,2",
            "tragger_time"=>"required_if:step,1|nullable|date_format:Y-m-d H:i:s"

        ];
    }

    public function messages(): array
{
    return [
        // analysis_patient_id
        'analysis_patient_id.required' => __('validation.The analysis patient ID field is required'),
        'analysis_patient_id.integer' => __('validation.The analysis patient ID must be an integer'),
        'analysis_patient_id.exists' => __('validation.The selected analysis patient ID is invalid'),

        // number_oocyte
        'number_oocyte.required' => __('validation.The number of oocytes field is required'),
        'number_oocyte.integer' => __('validation.The number of oocytes must be an integer'),

        // time
        'time.required' => __('validation.The time field is required'),
        'time.date_format' => __('validation.The time must be in the format H:i'),

        // report
        'report.required' => __('validation.The report field is required'),
        'report.string' => __('validation.The report must be a string'),
        'report.max' => __('validation.The report must not be greater than :max characters'),

        // step
        'step.required' => __('validation.The step field is required'),
        'step.integer' => __('validation.The step must be an integer'),
        'step.in' => __('validation.The step must be either 1 or 2'),

        // tragger_time
        'tragger_time.required_if' => __('validation.The trigger time field is required when step is 1'),
        'tragger_time.date_format' => __('validation.The trigger time must be in the format Y-m-d H:i:s'),
    ];
}
}
