<?php

namespace App\Http\Requests\Api\TestGroup;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use Illuminate\Foundation\Http\FormRequest;

class StepFourRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */

    /*
    public function authorize(): bool
    {
        return false;
    }*/

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {

        // dd(request());

        return [
            "analysis_patient_id" => "required|integer|exists:analysis_patients,id,type,test_group",
            "day" => "required|integer|min:1|max:6",
            "blastocyst" => "nullable|integer",
            "number_oocyte_fertilized" => "nullable|integer",
            "abnormal_fertilized" => "nullable|integer",
            "user_id" => "nullable|integer|exists:users,id",
            "report" => "required|string|max:100000",
            "media" => "nullable|array",
            "media.*" => "required|mimes:webm,mkv,flv,mp4,jpg,jpeg,png,pdf,doc,docs",
            "data" => "nullable|array",
            "data.*.number_embryos" => "required|integer",
            "data.*.number_cell" => "required|string|max:255",
            "data.*.number_grade" => "required|string|max:255",
            "data.*.time" => "required|date_format:H:i",


        ];
    }

    public function messages(): array
    {
        return [
            // analysis_patient_id
            'analysis_patient_id.required' => __('validation.The analysis patient ID field is required'),
            'analysis_patient_id.integer' => __('validation.The analysis patient ID must be an integer'),
            'analysis_patient_id.exists' => __('validation.The selected analysis patient ID is invalid'),

            // day
            'day.required' => __('validation.The day field is required'),
            'day.integer' => __('validation.The day must be an integer'),
            'day.min' => __('validation.The day must be at least :min'),
            'day.max' => __('validation.The day must not be greater than :max'),

            // blastocyst
            'blastocyst.integer' => __('validation.The blastocyst must be an integer'),

            // number_oocyte_fertilized
            'number_oocyte_fertilized.integer' => __('validation.The number of fertilized oocytes must be an integer'),

            // abnormal_fertilized
            'abnormal_fertilized.integer' => __('validation.The number of abnormal fertilized oocytes must be an integer'),

            // user_id
            'user_id.integer' => __('validation.The user ID must be an integer'),
            'user_id.exists' => __('validation.The selected user ID is invalid'),

            // report
            'report.required' => __('validation.The report field is required'),
            'report.string' => __('validation.The report must be a string'),
            'report.max' => __('validation.The report must not be greater than :max characters'),

            // media
            'media.array' => __('validation.The media must be an array'),
            'media.*.required' => __('validation.Each media file is required'),
            'media.*.mimes' => __('validation.Each media file must be of type: webm, mkv, flv, mp4, jpg, jpeg, png, pdf, doc, docs'),

            // data
            'data.array' => __('validation.The data must be an array'),
            'data.*.number_embryos.required' => __('validation.The number of embryos is required'),
            'data.*.number_embryos.integer' => __('validation.The number of embryos must be an integer'),
            'data.*.number_cell.required' => __('validation.The number of cells is required'),
            'data.*.number_cell.string' => __('validation.The number of cells must be a string'),
            'data.*.number_cell.max' => __('validation.The number of cells must not be greater than :max characters'),
            'data.*.number_grade.required' => __('validation.The grade number is required'),
            'data.*.number_grade.string' => __('validation.The grade number must be a string'),
            'data.*.number_grade.max' => __('validation.The grade number must not be greater than :max characters'),
            'data.*.time.required' => __('validation.The time is required'),
            'data.*.time.date_format' => __('validation.The time must be in the format H:i'),
        ];
    }
}
