<?php

namespace App\Http\Requests\Api\TestGroup;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use Illuminate\Foundation\Http\FormRequest;

class StepFiveRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */

    /*
    public function authorize(): bool
    {
        return false;
    }*/

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {


        return [
            "analysis_patient_id"=>"required|integer|exists:analysis_patients,id,type,test_group",
            "day"=>"required|integer|min:1|max:6",
            "count"=>"required|integer",
            "report"=>"required|string|max:100000",
            "assisted_hatched"=>"required|string|in:yes,no",
            "embryo_glue"=>"required|string|in:yes,no",
            "media"=>"required|string|max:255",
            "transfer_evaluation"=>"required|string|max:500000",
            "pregnancy_status"=>"nullable|string|in:pregnant,not_pregnant,miscarriage,not_returned",
            "evaluation_et"=>"nullable|string|in:very_bad,bad,accepted,good",
        ];
    }


    public function messages(): array
{
    return [
        'analysis_patient_id.required' => __('validation.The analysis patient ID field is required'),
        'analysis_patient_id.integer' => __('validation.The analysis patient ID must be an integer'),
        'analysis_patient_id.exists' => __('validation.The selected analysis patient ID is invalid'),

        'day.required' => __('validation.The day field is required'),
        'day.integer' => __('validation.The day must be an integer'),
        'day.min' => __('validation.The day must be at least :min'),
        'day.max' => __('validation.The day must not be greater than :max'),

        'count.required' => __('validation.The count field is required'),
        'count.integer' => __('validation.The count must be an integer'),

        'report.required' => __('validation.The report field is required'),
        'report.string' => __('validation.The report must be a string'),
        'report.max' => __('validation.The report must not be greater than :max characters'),

        'assisted_hatched.required' => __('validation.The assisted hatched field is required'),
        'assisted_hatched.string' => __('validation.The assisted hatched must be a string'),
        'assisted_hatched.in' => __('validation.The assisted hatched must be either "yes" or "no"'),

        'embryo_glue.required' => __('validation.The embryo glue field is required'),
        'embryo_glue.string' => __('validation.The embryo glue must be a string'),
        'embryo_glue.in' => __('validation.The embryo glue must be either "yes" or "no"'),

        'media.required' => __('validation.The media field is required'),
        'media.string' => __('validation.The media must be a string'),
        'media.max' => __('validation.The media must not be greater than :max characters'),

        'transfer_evaluation.required' => __('validation.The transfer evaluation field is required'),
        'transfer_evaluation.string' => __('validation.The transfer evaluation must be a string'),
        'transfer_evaluation.max' => __('validation.The transfer evaluation must not be greater than :max characters'),

        'pregnancy_status.string' => __('validation.The pregnancy status must be a string'),
        'pregnancy_status.in' => __('validation.The pregnancy status must be one of the following: pregnant, not pregnant, miscarriage, not returned'),

        'evaluation_et.string' => __('validation.The evaluation ET must be a string'),
        'evaluation_et.in' => __('validation.The evaluation ET must be one of the following: very bad, bad, accepted, good'),
    ];
}
}
