<?php

namespace App\Http\Requests\Api;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use App\Http\Helpers\HelperSetting;
use Illuminate\Foundation\Http\FormRequest;

class TaskRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */

    /*
    public function authorize(): bool
    {
        return false;
    }*/

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        $max =  HelperSetting::get_value('files_size_max_file_image') * 1024;

        return [
            "title" => "required|string|max:255",
            "description_task" => "required|string|max:100000",
            "to_user_id" => "required|integer|exists:users,id",
            "date" => "required|date_format:Y-m-d",
            "attachments" => "nullable|array",
            "attachments.*" => "required|file|mimes:webm,mkv,flv,mp4,jpg,jpeg,png,pdf,doc,docs|max:" . $max,
        ];
    }

    public function messages(): array
    {
        $max = HelperSetting::get_value('files_size_max_file_image') * 1024;

        return [
            // رسائل title
            'title.required' => __('validation.The title field is required'),
            'title.string' => __('validation.The title must be a string'),
            'title.max' => __('validation.The title may not be greater than :max characters'),

            // رسائل description_task
            'description_task.required' => __('validation.The description task field is required'),
            'description_task.string' => __('validation.The description task must be a string'),
            'description_task.max' => __('validation.The description task may not be greater than :max characters'),

            // رسائل to_user_id
            'to_user_id.required' => __('validation.The to user ID field is required'),
            'to_user_id.integer' => __('validation.The to user ID must be an integer'),
            'to_user_id.exists' => __('validation.The selected to user ID is invalid'),

            // رسائل date
            'date.required' => __('validation.The date field is required'),
            'date.date_format' => __('validation.The date must be in the format Y-m-d'),

            // رسائل attachments
            'attachments.array' => __('validation.The attachments must be an array'),

            // رسائل attachments.*
            'attachments.*.required' => __('validation.Each attachment is required'),
            'attachments.*.file' => __('validation.Each attachment must be a file'),
            'attachments.*.mimes' => __('validation.Each attachment must be of type: webm, mkv, flv, mp4, jpg, jpeg, png, pdf, doc, docs'),
            'attachments.*.max' => __('validation.Each attachment may not be greater than :max kilobytes'),
        ];
    }
}
