<?php

namespace App\Http\Requests\Api;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use App\Http\Helpers\HelperSetting;
use Illuminate\Foundation\Http\FormRequest;

class TaskReportRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */

    /*
    public function authorize(): bool
    {
        return false;
    }*/

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        $max =  HelperSetting::get_value('files_size_max_file_image') * 1024;

        return [
            "description_report_task" => "required|string|max:100000",
            "task_id" => "required|integer|exists:tasks,id",
            "attachments" => "nullable|array",
            "attachments.*" => "required|file|mimes:webm,mkv,flv,mp4,jpg,jpeg,png,pdf,doc,docs|max:" . $max,
        ];
    }

    public function messages(): array
    {

        return [
            // رسائل description_report_task
            'description_report_task.required' => __('validation.The description report task field is required'),
            'description_report_task.string' => __('validation.The description report task must be a string'),
            'description_report_task.max' => __('validation.The description report task may not be greater than :max characters'),

            // رسائل task_id
            'task_id.required' => __('validation.The task ID field is required'),
            'task_id.integer' => __('validation.The task ID must be an integer'),
            'task_id.exists' => __('validation.The selected task ID is invalid'),

            // رسائل attachments
            'attachments.array' => __('validation.The attachments must be an array'),

            // رسائل attachments.*
            'attachments.*.required' => __('validation.Each attachment is required'),
            'attachments.*.file' => __('validation.Each attachment must be a file'),
            'attachments.*.mimes' => __('validation.Each attachment must be of type: webm, mkv, flv, mp4, jpg, jpeg, png, pdf, doc, docs'),
            'attachments.*.max' => __('validation.Each attachment may not be greater than :max kilobytes'),
        ];
    }
}
