<?php

namespace App\Http\Requests\Api;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use Illuminate\Foundation\Http\FormRequest;

class StoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */

    /*
    public function authorize(): bool
    {
        return false;
    }*/

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
            "name"=>"required|string|max:255",
            "batch_number"=>"required|string|max:255",
            "manufacturer_date"=>"required|date|date_format:Y-m-d",
            "expiration_date"=>"required|date|date_format:Y-m-d",
            "date_of_open_and_use"=>"required|date|date_format:Y-m-d",
            "qty"=>"required|integer|max:10000",

        ];
    }

    public function messages(): array
{
    return [
        // رسائل name
        'name.required' => __('validation.The name field is required'),
        'name.string' => __('validation.The name must be a string'),
        'name.max' => __('validation.The name may not be greater than :max characters'),

        // رسائل batch_number
        'batch_number.required' => __('validation.The batch number field is required'),
        'batch_number.string' => __('validation.The batch number must be a string'),
        'batch_number.max' => __('validation.The batch number may not be greater than :max characters'),

        // رسائل manufacturer_date
        'manufacturer_date.required' => __('validation.The manufacturer date field is required'),
        'manufacturer_date.date' => __('validation.The manufacturer date must be a valid date'),
        'manufacturer_date.date_format' => __('validation.The manufacturer date must be in the format Y-m-d'),

        // رسائل expiration_date
        'expiration_date.required' => __('validation.The expiration date field is required'),
        'expiration_date.date' => __('validation.The expiration date must be a valid date'),
        'expiration_date.date_format' => __('validation.The expiration date must be in the format Y-m-d'),

        // رسائل date_of_open_and_use
        'date_of_open_and_use.required' => __('validation.The date of open and use field is required'),
        'date_of_open_and_use.date' => __('validation.The date of open and use must be a valid date'),
        'date_of_open_and_use.date_format' => __('validation.The date of open and use must be in the format Y-m-d'),

        // رسائل qty
        'qty.required' => __('validation.The quantity field is required'),
        'qty.integer' => __('validation.The quantity must be an integer'),
        'qty.max' => __('validation.The quantity may not be greater than :max'),
    ];
}
}
