<?php

namespace App\Http\Requests\Api;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use Illuminate\Foundation\Http\FormRequest;

class StoreQtyRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */

    /*
    public function authorize(): bool
    {
        return false;
    }*/

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
            "id"=>"required|integer|exists:stores,id",
            "new_qty"=>"required|integer|max:10000|min:0",
            "report"=>"required|string|max:100000"
        ];
    }

    public function messages(): array
{
    return [
        // رسائل id
        'id.required' => __('validation.The ID field is required'),
        'id.integer' => __('validation.The ID must be an integer'),
        'id.exists' => __('validation.The selected ID is invalid'),

        // رسائل new_qty
        'new_qty.required' => __('validation.The new quantity field is required'),
        'new_qty.integer' => __('validation.The new quantity must be an integer'),
        'new_qty.max' => __('validation.The new quantity may not be greater than :max'),
        'new_qty.min' => __('validation.The new quantity must be at least :min'),

        // رسائل report
        'report.required' => __('validation.The report field is required'),
        'report.string' => __('validation.The report must be a string'),
        'report.max' => __('validation.The report may not be greater than :max characters'),
    ];
}
}
