<?php

namespace App\Http\Requests\Api;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use Illuminate\Foundation\Http\FormRequest;

class SendReportGeneralRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */

    /*
    public function authorize(): bool
    {
        return false;
    }*/

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
            "analysis_patient_id" => "required|integer|exists:analysis_patients,id,type,general,is_sample_received,1",
            "abstinecece_days" => "required|integer|min:0",
            // "signature"=>"required|string|max:255",
            "notes" => "nullable|string|max:100000",
            "variables" => "required|array",
            "variables.*.id" => "required|integer|exists:variables,id|distinct",
            "variables.*.value" => "required|string|max:255",



        ];
    }

    public function messages(): array
    {
        return [
            // رسائل analysis_patient_id
            'analysis_patient_id.required' => __('validation.The analysis patient ID field is required'),
            'analysis_patient_id.integer' => __('validation.The analysis patient ID must be an integer'),
            'analysis_patient_id.exists' => __('validation.The selected analysis patient ID is invalid or does not meet the conditions'),

            // رسائل abstinecece_days
            'abstinecece_days.required' => __('validation.The abstinence days field is required'),
            'abstinecece_days.integer' => __('validation.The abstinence days must be an integer'),
            'abstinecece_days.min' => __('validation.The abstinence days must be at least :min'),

            // رسائل notes
            'notes.string' => __('validation.The notes must be a string'),
            'notes.max' => __('validation.The notes may not be greater than :max characters'),

            // رسائل variables
            'variables.required' => __('validation.The variables field is required'),
            'variables.array' => __('validation.The variables must be an array'),

            // رسائل variables.*.id
            'variables.*.id.required' => __('validation.The variable ID field is required'),
            'variables.*.id.integer' => __('validation.The variable ID must be an integer'),
            'variables.*.id.exists' => __('validation.The selected variable ID is invalid'),
            'variables.*.id.distinct' => __('validation.The variable IDs must be unique'),

            // رسائل variables.*.value
            'variables.*.value.required' => __('validation.The variable value field is required'),
            'variables.*.value.string' => __('validation.The variable value must be a string'),
            'variables.*.value.max' => __('validation.The variable value may not be greater than :max characters'),
        ];
    }
}
