<?php

namespace App\Http\Requests\Api\QualityManagement;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use Illuminate\Foundation\Http\FormRequest;

class WorkstationsAndLaminarFlowCabinetsRequestCreate extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */

    /*
    public function authorize(): bool
    {
        return false;
    }*/

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
            "laminars" => "required|array|min:1",

            'laminars.*.device_id' => 'required|integer|exists:devices,id',
            //'laminars.*.laminar_flow_id_or_name' => 'required|string|max:255',
            'laminars.*.heating_stage_temperature' => 'required|numeric|min:-273.15|max:10000',
            'laminars.*.filter_installation_date' => 'required|date_format:Y-m-d',
            'laminars.*.cleaning_date' => 'required|date_format:Y-m-d',
            'laminars.*.next_cleaning_date' => 'required|date_format:Y-m-d',
            'laminars.*.report' => 'required|string|max:100000',
            "laminars.*.evaluation" => "required|string|in:very_bad,bad,accepted,good",

        ];
    }
    public function messages(): array
    {
        return [
            'laminars.required' => __('validation.The laminars field is required'),
            'laminars.array' => __('validation.The laminars must be an array'),
            'laminars.min' => __('validation.The laminars must have at least :min item', ['min' => 1]),

            'laminars.*.device_id.required' => __('validation.The device ID field is required'),
            'laminars.*.device_id.integer' => __('validation.The device ID must be an integer'),
            'laminars.*.device_id.exists' => __('validation.The selected device ID is invalid'),

            'laminars.*.heating_stage_temperature.required' => __('validation.The heating stage temperature field is required'),
            'laminars.*.heating_stage_temperature.numeric' => __('validation.The heating stage temperature must be a number'),
            'laminars.*.heating_stage_temperature.min' => __('validation.The heating stage temperature must be at least :min', ['min' => -273.15]),
            'laminars.*.heating_stage_temperature.max' => __('validation.The heating stage temperature may not be greater than :max', ['max' => 10000]),

            'laminars.*.filter_installation_date.required' => __('validation.The filter installation date field is required'),
            'laminars.*.filter_installation_date.date_format' => __('validation.The filter installation date must be in the format Y-m-d'),

            'laminars.*.cleaning_date.required' => __('validation.The cleaning date field is required'),
            'laminars.*.cleaning_date.date_format' => __('validation.The cleaning date must be in the format Y-m-d'),

            'laminars.*.next_cleaning_date.required' => __('validation.The next cleaning date field is required'),
            'laminars.*.next_cleaning_date.date_format' => __('validation.The next cleaning date must be in the format Y-m-d'),

            'laminars.*.report.required' => __('validation.The report field is required'),
            'laminars.*.report.string' => __('validation.The report must be a string'),
            'laminars.*.report.max' => __('validation.The report may not be greater than :max characters', ['max' => 100000]),

            'laminars.*.evaluation.required' => __('validation.The evaluation field is required'),
            'laminars.*.evaluation.string' => __('validation.The evaluation must be a string'),
            'laminars.*.evaluation.in' => __('validation.The evaluation must be one of the following: :values', ['values' => 'very_bad, bad, accepted, good']),
        ];
    }
}
