<?php

namespace App\Http\Requests\Api\QualityManagement;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use Illuminate\Foundation\Http\FormRequest;

class TankLiquidNitrogenLevelCheckRequestCreate extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */

    /*
    public function authorize(): bool
    {
        return false;
    }*/

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
      
            'tanks' => 'required|array',
            'tanks.*.device_id' => 'required|integer|exists:devices,id',
            'tanks.*.next_cleaning_date' => 'required|date_format:Y-m-d',
            'tanks.*.date_time' => 'required|date_format:Y-m-d H:i:s',
           // 'tanks.*.tank_number_or_name' => 'required|string|max:255',
            'tanks.*.liquid_n2_level' => 'required|numeric|min:0|max:100',
            //'tanks.*.check_by' => 'required|string|max:255',

        ];
    }


    public function messages(): array
{
    return [
        'tanks.required' => __('validation.The tanks field is required'),
        'tanks.array' => __('validation.The tanks must be an array'),

        'tanks.*.device_id.required' => __('validation.The device ID field is required'),
        'tanks.*.device_id.integer' => __('validation.The device ID must be an integer'),
        'tanks.*.device_id.exists' => __('validation.The selected device ID is invalid'),

        'tanks.*.next_cleaning_date.required' => __('validation.The next cleaning date field is required'),
        'tanks.*.next_cleaning_date.date_format' => __('validation.The next cleaning date must be in the format Y-m-d'),

        'tanks.*.date_time.required' => __('validation.The date time field is required'),
        'tanks.*.date_time.date_format' => __('validation.The date time must be in the format Y-m-d H:i:s'),

        'tanks.*.liquid_n2_level.required' => __('validation.The liquid N2 level field is required'),
        'tanks.*.liquid_n2_level.numeric' => __('validation.The liquid N2 level must be a number'),
        'tanks.*.liquid_n2_level.min' => __('validation.The liquid N2 level must be at least :min', ['min' => 0]),
        'tanks.*.liquid_n2_level.max' => __('validation.The liquid N2 level may not be greater than :max', ['max' => 100]),
    ];
}
}
