<?php

namespace App\Http\Requests\Api\QualityManagement;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use Illuminate\Foundation\Http\FormRequest;

class RefrigeratorsTemperatureLogRequestUpdate extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */

    /*
    public function authorize(): bool
    {
        return false;
    }*/

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
            'id' => "required|integer",
            'date_time' => 'required|date_format:Y-m-d H:i:s',
            'shift' => 'required|in:am,pm',
            'device_id' => 'required|integer',
            'temperature' => 'required|numeric',
            'report' => "nullable|string|max:100000"

        ];
    }

    public function messages(): array
    {
        return [
            'id.required' => __('validation.The ID field is required'),
            'id.integer' => __('validation.The ID must be an integer'),

            'date_time.required' => __('validation.The date time field is required'),
            'date_time.date_format' => __('validation.The date time must be in the format Y-m-d H:i:s'),

            'shift.required' => __('validation.The shift field is required'),
            'shift.in' => __('validation.The shift must be one of the following: :values', ['values' => 'am, pm']),

            'device_id.required' => __('validation.The device ID field is required'),
            'device_id.integer' => __('validation.The device ID must be an integer'),

            'temperature.required' => __('validation.The temperature field is required'),
            'temperature.numeric' => __('validation.The temperature must be a number'),

            'report.string' => __('validation.The report must be a string'),
            'report.max' => __('validation.The report may not be greater than :max characters', ['max' => 100000]),
        ];
    }
}
