<?php

namespace App\Http\Requests\Api\QualityManagement;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use Illuminate\Foundation\Http\FormRequest;

class RefrigeratorsTemperatureLogRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */

    /*
    public function authorize(): bool
    {
        return false;
    }*/

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
            'items'=>'required|array|min:1',
            'items.*.date_time' => 'required|date_format:Y-m-d H:i:s',
            'items.*.shift' => 'required|in:am,pm',
            'items.*.device_id' => 'required|integer',
            'items.*.temperature' => 'required|numeric',
            'items.*.report' => 'nullable|string|max:100000',
        ];
    }


    public function messages(): array
{
    return [
        'items.required' => __('validation.The items field is required'),
        'items.array' => __('validation.The items must be an array'),
        'items.min' => __('validation.The items must have at least :min item', ['min' => 1]),

        'items.*.date_time.required' => __('validation.The date time field is required'),
        'items.*.date_time.date_format' => __('validation.The date time must be in the format Y-m-d H:i:s'),

        'items.*.shift.required' => __('validation.The shift field is required'),
        'items.*.shift.in' => __('validation.The shift must be one of the following: :values', ['values' => 'am, pm']),

        'items.*.device_id.required' => __('validation.The device ID field is required'),
        'items.*.device_id.integer' => __('validation.The device ID must be an integer'),

        'items.*.temperature.required' => __('validation.The temperature field is required'),
        'items.*.temperature.numeric' => __('validation.The temperature must be a number'),

        'items.*.report.string' => __('validation.The report must be a string'),
        'items.*.report.max' => __('validation.The report may not be greater than :max characters', ['max' => 100000]),
    ];
}

}
