<?php

namespace App\Http\Requests\Api\QualityManagement;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use Illuminate\Foundation\Http\FormRequest;

class MicromanipulatorAndIcsiStationRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */

    /*
    public function authorize(): bool
    {
        return false;
    }*/

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [

            "id"=>"nullable|integer",
            'device_id' => 'required|integer|exists:devices,id',
           // 'id_or_name' => 'required|string|max:255',
            'laser_alignment_status' => 'required|in:good,acceptable,poor',
            'heating_stage_temperature' => 'required|numeric|min:-273.15|max:10000',
            'anti_vibration_tables_status' => 'required|in:good,acceptable,poor',
            'electronic_systems_status' => 'required|in:good,acceptable,poor',
            'cleaning_date' => 'required|date_format:Y-m-d',
            'next_cleaning_date' => 'required|date_format:Y-m-d',
            'check_by' => 'required|string|max:255',


        ];
    }

    public function messages(): array
    {
        return [
            'id.nullable' => __('validation.The ID field is optional'),
            'id.integer' => __('validation.The ID must be an integer'),

            'device_id.required' => __('validation.The device ID field is required'),
            'device_id.integer' => __('validation.The device ID must be an integer'),
            'device_id.exists' => __('validation.The selected device ID is invalid'),

            'laser_alignment_status.required' => __('validation.The laser alignment status field is required'),
            'laser_alignment_status.in' => __('validation.The laser alignment status must be one of the following: :values', ['values' => 'good, acceptable, poor']),

            'heating_stage_temperature.required' => __('validation.The heating stage temperature field is required'),
            'heating_stage_temperature.numeric' => __('validation.The heating stage temperature must be a number'),
            'heating_stage_temperature.min' => __('validation.The heating stage temperature must be at least :min', ['min' => -273.15]),
            'heating_stage_temperature.max' => __('validation.The heating stage temperature may not be greater than :max', ['max' => 10000]),

            'anti_vibration_tables_status.required' => __('validation.The anti-vibration tables status field is required'),
            'anti_vibration_tables_status.in' => __('validation.The anti-vibration tables status must be one of the following: :values', ['values' => 'good, acceptable, poor']),

            'electronic_systems_status.required' => __('validation.The electronic systems status field is required'),
            'electronic_systems_status.in' => __('validation.The electronic systems status must be one of the following: :values', ['values' => 'good, acceptable, poor']),

            'cleaning_date.required' => __('validation.The cleaning date field is required'),
            'cleaning_date.date_format' => __('validation.The cleaning date must be in the format Y-m-d'),

            'next_cleaning_date.required' => __('validation.The next cleaning date field is required'),
            'next_cleaning_date.date_format' => __('validation.The next cleaning date must be in the format Y-m-d'),

            'check_by.required' => __('validation.The check by field is required'),
            'check_by.string' => __('validation.The check by must be a string'),
            'check_by.max' => __('validation.The check by may not be greater than :max characters', ['max' => 255]),
        ];
    }
}
