<?php

namespace App\Http\Requests\Api\QualityManagement;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use Illuminate\Foundation\Http\FormRequest;

class LabEnvironmentRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */

    /*
    public function authorize(): bool
    {
        return false;
    }*/

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
          //  'device_id' => 'required|integer|exists:devices,id',
            'next_cleaning_date' => 'required|date_format:Y-m-d',
            'voc' => 'required|numeric|max:1000',
            'humidity' => 'required|numeric|max:1000',
            'temperature' => 'required|numeric|max:1000',
           // 'check_by' => 'required|string|max:255',
        ];
    }

    public function messages(): array
{
    return [
        'next_cleaning_date.required' => __('validation.The next cleaning date field is required'),
        'next_cleaning_date.date_format' => __('validation.The next cleaning date must be in the format Y-m-d'),

        'voc.required' => __('validation.The VOC field is required'),
        'voc.numeric' => __('validation.The VOC must be a number'),
        'voc.max' => __('validation.The VOC may not be greater than :max', ['max' => 1000]),

        'humidity.required' => __('validation.The humidity field is required'),
        'humidity.numeric' => __('validation.The humidity must be a number'),
        'humidity.max' => __('validation.The humidity may not be greater than :max', ['max' => 1000]),

        'temperature.required' => __('validation.The temperature field is required'),
        'temperature.numeric' => __('validation.The temperature must be a number'),
        'temperature.max' => __('validation.The temperature may not be greater than :max', ['max' => 1000]),
    ];
}
}
