<?php

namespace App\Http\Requests\Api\QualityManagement;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use Illuminate\Foundation\Http\FormRequest;

class IncubatorQualityControlLogRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */

    /*
    public function authorize(): bool
    {
        return false;
    }*/

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
            'id'=>"nullable|integer|exists:q_m_incubator_quality_control_logs,id",
            'device_id'=>"required|integer|exists:devices,id",
            'date' => 'required|date_format:Y-m-d',
            //'incubator_name' => 'required|string|max:255',
            'temperature' => 'required|numeric|min:-273.15|max:10000', // assuming extreme values
            'water_level' => 'required|numeric|min:0|max:100',
            'co2_level' => 'required|numeric|min:0|max:100',
            'o2_level' => 'required|numeric|min:0|max:100',
            'n2_level' => 'required|numeric|min:0|max:100',
            'humidity' => 'required|numeric|min:0|max:100',
            'ph_of_culture_medium' => 'required|numeric|min:0|max:14',
            'lot_number_culture_medium' => 'required|string|max:255',
            'uv_lamp_installation_date' => 'required|date_format:Y-m-d H:i:s',
            'hepa_filter_installation_date' => 'required|date_format:Y-m-d H:i:s',
            'cleaning_date' => 'required|date_format:Y-m-d',
            'next_cleaning_date' => 'required|date_format:Y-m-d',
            'report' => 'required|string|max:100000',
            "evaluation"=>"required|string|in:very_bad,bad,accepted,good",
        ];
    }

    public function messages(): array
{
    return [
        'id.nullable' => __('validation.The ID field is optional'),
        'id.integer' => __('validation.The ID must be an integer'),
        'id.exists' => __('validation.The selected ID is invalid'),

        'device_id.required' => __('validation.The device ID field is required'),
        'device_id.integer' => __('validation.The device ID must be an integer'),
        'device_id.exists' => __('validation.The selected device ID is invalid'),

        'date.required' => __('validation.The date field is required'),
        'date.date_format' => __('validation.The date must be in the format Y-m-d'),

        'temperature.required' => __('validation.The temperature field is required'),
        'temperature.numeric' => __('validation.The temperature must be a number'),
        'temperature.min' => __('validation.The temperature must be at least :min', ['min' => -273.15]),
        'temperature.max' => __('validation.The temperature may not be greater than :max', ['max' => 10000]),

        'water_level.required' => __('validation.The water level field is required'),
        'water_level.numeric' => __('validation.The water level must be a number'),
        'water_level.min' => __('validation.The water level must be at least :min', ['min' => 0]),
        'water_level.max' => __('validation.The water level may not be greater than :max', ['max' => 100]),

        'co2_level.required' => __('validation.The CO2 level field is required'),
        'co2_level.numeric' => __('validation.The CO2 level must be a number'),
        'co2_level.min' => __('validation.The CO2 level must be at least :min', ['min' => 0]),
        'co2_level.max' => __('validation.The CO2 level may not be greater than :max', ['max' => 100]),

        'o2_level.required' => __('validation.The O2 level field is required'),
        'o2_level.numeric' => __('validation.The O2 level must be a number'),
        'o2_level.min' => __('validation.The O2 level must be at least :min', ['min' => 0]),
        'o2_level.max' => __('validation.The O2 level may not be greater than :max', ['max' => 100]),

        'n2_level.required' => __('validation.The N2 level field is required'),
        'n2_level.numeric' => __('validation.The N2 level must be a number'),
        'n2_level.min' => __('validation.The N2 level must be at least :min', ['min' => 0]),
        'n2_level.max' => __('validation.The N2 level may not be greater than :max', ['max' => 100]),

        'humidity.required' => __('validation.The humidity field is required'),
        'humidity.numeric' => __('validation.The humidity must be a number'),
        'humidity.min' => __('validation.The humidity must be at least :min', ['min' => 0]),
        'humidity.max' => __('validation.The humidity may not be greater than :max', ['max' => 100]),

        'ph_of_culture_medium.required' => __('validation.The pH of culture medium field is required'),
        'ph_of_culture_medium.numeric' => __('validation.The pH of culture medium must be a number'),
        'ph_of_culture_medium.min' => __('validation.The pH of culture medium must be at least :min', ['min' => 0]),
        'ph_of_culture_medium.max' => __('validation.The pH of culture medium may not be greater than :max', ['max' => 14]),

        'lot_number_culture_medium.required' => __('validation.The lot number of culture medium field is required'),
        'lot_number_culture_medium.string' => __('validation.The lot number of culture medium must be a string'),
        'lot_number_culture_medium.max' => __('validation.The lot number of culture medium may not be greater than :max characters', ['max' => 255]),

        'uv_lamp_installation_date.required' => __('validation.The UV lamp installation date field is required'),
        'uv_lamp_installation_date.date_format' => __('validation.The UV lamp installation date must be in the format Y-m-d H:i:s'),

        'hepa_filter_installation_date.required' => __('validation.The HEPA filter installation date field is required'),
        'hepa_filter_installation_date.date_format' => __('validation.The HEPA filter installation date must be in the format Y-m-d H:i:s'),

        'cleaning_date.required' => __('validation.The cleaning date field is required'),
        'cleaning_date.date_format' => __('validation.The cleaning date must be in the format Y-m-d'),

        'next_cleaning_date.required' => __('validation.The next cleaning date field is required'),
        'next_cleaning_date.date_format' => __('validation.The next cleaning date must be in the format Y-m-d'),

        'report.required' => __('validation.The report field is required'),
        'report.string' => __('validation.The report must be a string'),
        'report.max' => __('validation.The report may not be greater than :max characters', ['max' => 100000]),

        'evaluation.required' => __('validation.The evaluation field is required'),
        'evaluation.string' => __('validation.The evaluation must be a string'),
        'evaluation.in' => __('validation.The evaluation must be one of the following: :values', ['values' => 'very_bad, bad, accepted, good']),
    ];
}
}
