<?php

namespace App\Http\Requests\Api\QualityManagement;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use Illuminate\Foundation\Http\FormRequest;

class HeatedIncubatorRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */

    /*
    public function authorize(): bool
    {
        return false;
    }*/

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
            'date' => 'required|date_format:Y-m-d',
            //'incubator_name' => 'required|string|max:255',
            'temperature' => 'required|numeric|min:-273.15|max:10000',
            'water_level' => 'required|numeric|min:0|max:100',
            'humidity' => 'required|numeric|min:0|max:100',
            'cleaning_date' => 'required|date_format:Y-m-d',
            'next_cleaning_date' => 'required|date_format:Y-m-d',
            'report' => 'required|string|max:100000',
            'device_id' => 'required|integer|exists:devices,id',
        ];
    }


    public function messages(): array
    {
        return [
            'date.required' => __('validation.The date field is required'),
            'date.date_format' => __('validation.The date must be in the format Y-m-d'),

            'temperature.required' => __('validation.The temperature field is required'),
            'temperature.numeric' => __('validation.The temperature must be a number'),
            'temperature.min' => __('validation.The temperature must be at least :min', ['min' => -273.15]),
            'temperature.max' => __('validation.The temperature may not be greater than :max', ['max' => 10000]),

            'water_level.required' => __('validation.The water level field is required'),
            'water_level.numeric' => __('validation.The water level must be a number'),
            'water_level.min' => __('validation.The water level must be at least :min', ['min' => 0]),
            'water_level.max' => __('validation.The water level may not be greater than :max', ['max' => 100]),

            'humidity.required' => __('validation.The humidity field is required'),
            'humidity.numeric' => __('validation.The humidity must be a number'),
            'humidity.min' => __('validation.The humidity must be at least :min', ['min' => 0]),
            'humidity.max' => __('validation.The humidity may not be greater than :max', ['max' => 100]),

            'cleaning_date.required' => __('validation.The cleaning date field is required'),
            'cleaning_date.date_format' => __('validation.The cleaning date must be in the format Y-m-d'),

            'next_cleaning_date.required' => __('validation.The next cleaning date field is required'),
            'next_cleaning_date.date_format' => __('validation.The next cleaning date must be in the format Y-m-d'),

            'report.required' => __('validation.The report field is required'),
            'report.string' => __('validation.The report must be a string'),
            'report.max' => __('validation.The report may not be greater than :max characters', ['max' => 100000]),

            'device_id.required' => __('validation.The device ID field is required'),
            'device_id.integer' => __('validation.The device ID must be an integer'),
            'device_id.exists' => __('validation.The selected device ID is invalid'),
        ];
    }
}
