<?php

namespace App\Http\Requests\Api\QualityManagement;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use Illuminate\Foundation\Http\FormRequest;

class GeneralLabCleaningRequestUpdate extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */

    /*
    public function authorize(): bool
    {
        return false;
    }*/

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */

    public function rules(): array
    {
        return [

            'id'=>"required|integer",
            'general_lab_cleaning' => 'required|in:surface,wall,corner,floor,instruments,cupboard',
            'cleaning_date' => 'required|date',
            'cleaned_by' => 'required|string|max:255',
            'next_cleaning_date' => 'required|date',
            'report' => 'required|string|max:100000',
        ];
    }


    public function messages(): array
{
    return [
        'id.required' => __('validation.The ID field is required'),
        'id.integer' => __('validation.The ID must be an integer'),

        'general_lab_cleaning.required' => __('validation.The general lab cleaning field is required'),
        'general_lab_cleaning.in' => __('validation.The general lab cleaning must be one of the following: :values', ['values' => 'surface, wall, corner, floor, instruments, cupboard']),

        'cleaning_date.required' => __('validation.The cleaning date field is required'),
        'cleaning_date.date' => __('validation.The cleaning date must be a valid date'),

        'cleaned_by.required' => __('validation.The cleaned by field is required'),
        'cleaned_by.string' => __('validation.The cleaned by must be a string'),
        'cleaned_by.max' => __('validation.The cleaned by may not be greater than :max characters', ['max' => 255]),

        'next_cleaning_date.required' => __('validation.The next cleaning date field is required'),
        'next_cleaning_date.date' => __('validation.The next cleaning date must be a valid date'),

        'report.required' => __('validation.The report field is required'),
        'report.string' => __('validation.The report must be a string'),
        'report.max' => __('validation.The report may not be greater than :max characters', ['max' => 100000]),
    ];
}



}
