<?php

namespace App\Http\Requests\Api\QualityManagement;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use Illuminate\Foundation\Http\FormRequest;

class GeneralLabCleaningRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */

    /*
    public function authorize(): bool
    {
        return false;
    }*/

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */

    public function rules(): array
    {
        return [

            'items' => "required|array|min:1",
            'items.*.general_lab_cleaning' => 'required|in:surface,wall,corner,floor,instruments,cupboard',
            'items.*.cleaning_date' => 'required|date',
            'items.*.cleaned_by' => 'required|string|max:255',
            'items.*.next_cleaning_date' => 'required|date',
            'items.*.report' => 'required|string|max:100000',
        ];
    }

    public function messages(): array
    {
        return [
            'items.required' => __('validation.The items field is required'),
            'items.array' => __('validation.The items must be an array'),
            'items.min' => __('validation.The items must have at least :min item', ['min' => 1]),

            'items.*.general_lab_cleaning.required' => __('validation.The general lab cleaning field is required'),
            'items.*.general_lab_cleaning.in' => __('validation.The general lab cleaning must be one of the following: :values', ['values' => 'surface, wall, corner, floor, instruments, cupboard']),

            'items.*.cleaning_date.required' => __('validation.The cleaning date field is required'),
            'items.*.cleaning_date.date' => __('validation.The cleaning date must be a valid date'),

            'items.*.cleaned_by.required' => __('validation.The cleaned by field is required'),
            'items.*.cleaned_by.string' => __('validation.The cleaned by must be a string'),
            'items.*.cleaned_by.max' => __('validation.The cleaned by may not be greater than :max characters', ['max' => 255]),

            'items.*.next_cleaning_date.required' => __('validation.The next cleaning date field is required'),
            'items.*.next_cleaning_date.date' => __('validation.The next cleaning date must be a valid date'),

            'items.*.report.required' => __('validation.The report field is required'),
            'items.*.report.string' => __('validation.The report must be a string'),
            'items.*.report.max' => __('validation.The report may not be greater than :max characters', ['max' => 100000]),
        ];
    }
}
