<?php

namespace App\Http\Requests\Api\QualityManagement;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use Illuminate\Foundation\Http\FormRequest;

class Co2AndN2CylinderGasLevelCheckRequestUpdate extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */

    /*
    public function authorize(): bool
    {
        return false;
    }*/

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
            'id'=>'required|integer',
            'device_id' => 'required|integer|exists:devices,id',
            //'incubator_name' => 'required|string|max:255',
            'next_cleaning_date' => 'required|date_format:Y-m-d',
            'date_time' => 'required|date_format:Y-m-d H:i:s',
           // 'cylinder_no' => 'required|string|max:255',
            'co2_level' => 'required|numeric|min:0|max:100',
            'n2_level' => 'required|numeric|min:0|max:100',
           // 'check_by' => 'required|string|max:255',
        ];
    }


    public function messages(): array
{
    return [
        'id.required' => __('validation.The ID field is required'),
        'id.integer' => __('validation.The ID must be an integer'),

        'device_id.required' => __('validation.The device ID field is required'),
        'device_id.integer' => __('validation.The device ID must be an integer'),
        'device_id.exists' => __('validation.The selected device ID is invalid'),

        'next_cleaning_date.required' => __('validation.The next cleaning date field is required'),
        'next_cleaning_date.date_format' => __('validation.The next cleaning date must be in the format Y-m-d'),

        'date_time.required' => __('validation.The date time field is required'),
        'date_time.date_format' => __('validation.The date time must be in the format Y-m-d H:i:s'),

        'co2_level.required' => __('validation.The CO2 level field is required'),
        'co2_level.numeric' => __('validation.The CO2 level must be a number'),
        'co2_level.min' => __('validation.The CO2 level must be at least :min', ['min' => 0]),
        'co2_level.max' => __('validation.The CO2 level may not be greater than :max', ['max' => 100]),

        'n2_level.required' => __('validation.The N2 level field is required'),
        'n2_level.numeric' => __('validation.The N2 level must be a number'),
        'n2_level.min' => __('validation.The N2 level must be at least :min', ['min' => 0]),
        'n2_level.max' => __('validation.The N2 level may not be greater than :max', ['max' => 100]),
    ];
}
}
