<?php

namespace App\Http\Requests\Api\QualityManagement;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use Illuminate\Foundation\Http\FormRequest;

class Co2AndN2CylinderGasLevelCheckRequestCreate extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */

    /*
    public function authorize(): bool
    {
        return false;
    }*/

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [



            'cylinders' => 'required|array|min:1',
            'cylinders.*.device_id' => 'required|integer|exists:devices,id',
            'cylinders.*.next_cleaning_date' => 'required|date_format:Y-m-d',
         //   'cylinders.*.incubator_name' => 'required|string|max:255',
            'cylinders.*.date_time' => 'required|date_format:Y-m-d H:i:s',
          //  'cylinders.*.cylinder_no' => 'required|string|max:255',
            'cylinders.*.co2_level' => 'required|numeric|min:0|max:100',
            'cylinders.*.n2_level' => 'required|numeric|min:0|max:100',
            'cylinders.*.check_by' => 'required|string|max:255',
        ];
    }

    public function messages(): array
{
    return [
        'cylinders.required' => __('validation.The cylinders field is required'),
        'cylinders.array' => __('validation.The cylinders must be an array'),
        'cylinders.min' => __('validation.The cylinders must have at least :min item', ['min' => 1]),

        'cylinders.*.device_id.required' => __('validation.The device ID field is required'),
        'cylinders.*.device_id.integer' => __('validation.The device ID must be an integer'),
        'cylinders.*.device_id.exists' => __('validation.The selected device ID is invalid'),

        'cylinders.*.next_cleaning_date.required' => __('validation.The next cleaning date field is required'),
        'cylinders.*.next_cleaning_date.date_format' => __('validation.The next cleaning date must be in the format Y-m-d'),

        'cylinders.*.date_time.required' => __('validation.The date time field is required'),
        'cylinders.*.date_time.date_format' => __('validation.The date time must be in the format Y-m-d H:i:s'),

        'cylinders.*.co2_level.required' => __('validation.The CO2 level field is required'),
        'cylinders.*.co2_level.numeric' => __('validation.The CO2 level must be a number'),
        'cylinders.*.co2_level.min' => __('validation.The CO2 level must be at least :min', ['min' => 0]),
        'cylinders.*.co2_level.max' => __('validation.The CO2 level may not be greater than :max', ['max' => 100]),

        'cylinders.*.n2_level.required' => __('validation.The N2 level field is required'),
        'cylinders.*.n2_level.numeric' => __('validation.The N2 level must be a number'),
        'cylinders.*.n2_level.min' => __('validation.The N2 level must be at least :min', ['min' => 0]),
        'cylinders.*.n2_level.max' => __('validation.The N2 level may not be greater than :max', ['max' => 100]),

        'cylinders.*.check_by.required' => __('validation.The check by field is required'),
        'cylinders.*.check_by.string' => __('validation.The check by must be a string'),
        'cylinders.*.check_by.max' => __('validation.The check by may not be greater than :max characters', ['max' => 255]),
    ];
}
}
