<?php

namespace App\Http\Requests\Api\QualityManagement;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use Illuminate\Foundation\Http\FormRequest;

class AirPurifiersDeviceRequestUpdate extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */

    /*
    public function authorize(): bool
    {
        return false;
    }*/

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
            "id" => "required|integer",
            'device_id' => 'required|integer|exists:devices,id',
            'incubator_name' => 'required|string|max:255',
            'evaluation' => 'required|in:very_bad,bad,accepted,good',
            'next_cleaning_date' => 'required|date_format:Y-m-d',
            'report' => 'required|string|max:100000',
            //'device_name_or_id' => 'required|string|max:255',
            'installation_date' => 'required|date_format:Y-m-d',
            'next_change_date' => 'required|date_format:Y-m-d',
            'pre_filters_date_install' => 'required|date_format:Y-m-d',
            'pre_filters_date_change' => 'required|date_format:Y-m-d',
            'carbon_filters_date_install' => 'required|date_format:Y-m-d',
            'carbon_filters_date_change' => 'required|date_format:Y-m-d',
            'ulpa_filters_date_install' => 'required|date_format:Y-m-d',
            'ulpa_filters_date_change' => 'required|date_format:Y-m-d',
            'hepa_filters_date_install' => 'required|date_format:Y-m-d',
            'hepa_filters_date_change' => 'required|date_format:Y-m-d',
        ];
    }


    public function messages(): array
    {
        return [
            'id.required' => __('validation.The ID field is required'),
            'id.integer' => __('validation.The ID must be an integer'),

            'device_id.required' => __('validation.The device ID field is required'),
            'device_id.integer' => __('validation.The device ID must be an integer'),
            'device_id.exists' => __('validation.The selected device ID is invalid'),

            'incubator_name.required' => __('validation.The incubator name field is required'),
            'incubator_name.string' => __('validation.The incubator name must be a string'),
            'incubator_name.max' => __('validation.The incubator name may not be greater than :max characters', ['max' => 255]),

            'evaluation.required' => __('validation.The evaluation field is required'),
            'evaluation.in' => __('validation.The evaluation must be one of the following: :values', ['values' => 'very_bad, bad, accepted, good']),

            'next_cleaning_date.required' => __('validation.The next cleaning date field is required'),
            'next_cleaning_date.date_format' => __('validation.The next cleaning date must be in the format Y-m-d'),

            'report.required' => __('validation.The report field is required'),
            'report.string' => __('validation.The report must be a string'),
            'report.max' => __('validation.The report may not be greater than :max characters', ['max' => 100000]),

            'installation_date.required' => __('validation.The installation date field is required'),
            'installation_date.date_format' => __('validation.The installation date must be in the format Y-m-d'),

            'next_change_date.required' => __('validation.The next change date field is required'),
            'next_change_date.date_format' => __('validation.The next change date must be in the format Y-m-d'),

            'pre_filters_date_install.required' => __('validation.The pre filters installation date field is required'),
            'pre_filters_date_install.date_format' => __('validation.The pre filters installation date must be in the format Y-m-d'),

            'pre_filters_date_change.required' => __('validation.The pre filters change date field is required'),
            'pre_filters_date_change.date_format' => __('validation.The pre filters change date must be in the format Y-m-d'),

            'carbon_filters_date_install.required' => __('validation.The carbon filters installation date field is required'),
            'carbon_filters_date_install.date_format' => __('validation.The carbon filters installation date must be in the format Y-m-d'),

            'carbon_filters_date_change.required' => __('validation.The carbon filters change date field is required'),
            'carbon_filters_date_change.date_format' => __('validation.The carbon filters change date must be in the format Y-m-d'),

            'ulpa_filters_date_install.required' => __('validation.The ULPA filters installation date field is required'),
            'ulpa_filters_date_install.date_format' => __('validation.The ULPA filters installation date must be in the format Y-m-d'),

            'ulpa_filters_date_change.required' => __('validation.The ULPA filters change date field is required'),
            'ulpa_filters_date_change.date_format' => __('validation.The ULPA filters change date must be in the format Y-m-d'),

            'hepa_filters_date_install.required' => __('validation.The HEPA filters installation date field is required'),
            'hepa_filters_date_install.date_format' => __('validation.The HEPA filters installation date must be in the format Y-m-d'),

            'hepa_filters_date_change.required' => __('validation.The HEPA filters change date field is required'),
            'hepa_filters_date_change.date_format' => __('validation.The HEPA filters change date must be in the format Y-m-d'),
        ];
    }
}
