<?php

namespace App\Http\Requests\Api\QualityManagement;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use Illuminate\Foundation\Http\FormRequest;

class AirPurifiersDeviceRequestCreate extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */

    /*
    public function authorize(): bool
    {
        return false;
    }*/

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
            'devices' => 'required|array|min:1',

            'devices.*.device_id' => 'required|integer|exists:devices,id',
            // 'incubator_name' => 'required|string|max:255',
            'devices.*.evaluation' => 'required|in:very_bad,bad,accepted,good',
            'devices.*.next_cleaning_date' => 'required|date_format:Y-m-d',
            'devices.*.report' => 'required|string|max:100000',
            //'devices.*.device_name_or_id' => 'required|string|max:255',
            'devices.*.installation_date' => 'required|date_format:Y-m-d',
            'devices.*.next_change_date' => 'required|date_format:Y-m-d',
            'devices.*.pre_filters_date_install' => 'required|date_format:Y-m-d',
            'devices.*.pre_filters_date_change' => 'required|date_format:Y-m-d',
            'devices.*.carbon_filters_date_install' => 'required|date_format:Y-m-d',
            'devices.*.carbon_filters_date_change' => 'required|date_format:Y-m-d',
            'devices.*.ulpa_filters_date_install' => 'required|date_format:Y-m-d',
            'devices.*.ulpa_filters_date_change' => 'required|date_format:Y-m-d',
            'devices.*.hepa_filters_date_install' => 'required|date_format:Y-m-d',
            'devices.*.hepa_filters_date_change' => 'required|date_format:Y-m-d',
        ];
    }

    public function messages(): array
{
    return [
        'devices.required' => __('validation.The devices field is required'),
        'devices.array' => __('validation.The devices must be an array'),
        'devices.min' => __('validation.The devices must have at least :min item', ['min' => 1]),

        'devices.*.device_id.required' => __('validation.The device ID field is required'),
        'devices.*.device_id.integer' => __('validation.The device ID must be an integer'),
        'devices.*.device_id.exists' => __('validation.The selected device ID is invalid'),

        'devices.*.evaluation.required' => __('validation.The evaluation field is required'),
        'devices.*.evaluation.in' => __('validation.The evaluation must be one of the following: :values', ['values' => 'very_bad, bad, accepted, good']),

        'devices.*.next_cleaning_date.required' => __('validation.The next cleaning date field is required'),
        'devices.*.next_cleaning_date.date_format' => __('validation.The next cleaning date must be in the format Y-m-d'),

        'devices.*.report.required' => __('validation.The report field is required'),
        'devices.*.report.string' => __('validation.The report must be a string'),
        'devices.*.report.max' => __('validation.The report may not be greater than :max characters', ['max' => 100000]),

        'devices.*.installation_date.required' => __('validation.The installation date field is required'),
        'devices.*.installation_date.date_format' => __('validation.The installation date must be in the format Y-m-d'),

        'devices.*.next_change_date.required' => __('validation.The next change date field is required'),
        'devices.*.next_change_date.date_format' => __('validation.The next change date must be in the format Y-m-d'),

        'devices.*.pre_filters_date_install.required' => __('validation.The pre filters installation date field is required'),
        'devices.*.pre_filters_date_install.date_format' => __('validation.The pre filters installation date must be in the format Y-m-d'),

        'devices.*.pre_filters_date_change.required' => __('validation.The pre filters change date field is required'),
        'devices.*.pre_filters_date_change.date_format' => __('validation.The pre filters change date must be in the format Y-m-d'),

        'devices.*.carbon_filters_date_install.required' => __('validation.The carbon filters installation date field is required'),
        'devices.*.carbon_filters_date_install.date_format' => __('validation.The carbon filters installation date must be in the format Y-m-d'),

        'devices.*.carbon_filters_date_change.required' => __('validation.The carbon filters change date field is required'),
        'devices.*.carbon_filters_date_change.date_format' => __('validation.The carbon filters change date must be in the format Y-m-d'),

        'devices.*.ulpa_filters_date_install.required' => __('validation.The ULPA filters installation date field is required'),
        'devices.*.ulpa_filters_date_install.date_format' => __('validation.The ULPA filters installation date must be in the format Y-m-d'),

        'devices.*.ulpa_filters_date_change.required' => __('validation.The ULPA filters change date field is required'),
        'devices.*.ulpa_filters_date_change.date_format' => __('validation.The ULPA filters change date must be in the format Y-m-d'),

        'devices.*.hepa_filters_date_install.required' => __('validation.The HEPA filters installation date field is required'),
        'devices.*.hepa_filters_date_install.date_format' => __('validation.The HEPA filters installation date must be in the format Y-m-d'),

        'devices.*.hepa_filters_date_change.required' => __('validation.The HEPA filters change date field is required'),
        'devices.*.hepa_filters_date_change.date_format' => __('validation.The HEPA filters change date must be in the format Y-m-d'),
    ];
}
}
