<?php

namespace App\Http\Requests\Api;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/

use App\Enums\MaleFactorEnum;
use App\Enums\FemaleFactorEnum;
use App\Enums\ProtocolTypeEnum;
use App\Http\Helpers\HelperSetting;
use Illuminate\Foundation\Http\FormRequest;

class ProtocolRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */

    /*
    public function authorize(): bool
    {
        return false;
    }*/

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        $max =  HelperSetting::get_value('files_size_max_file_image') * 1024;

        return [
            'analysis_patient_id' => 'required|integer|exists:analysis_patients,id,type,general',
            'duration_of_infertility' => 'required|integer|min:0|max:100',
            'number_of_children' => 'required|integer|min:0|max:20',
            'number_of_miscarriages' => 'required|integer|min:0|max:20',
            'previous_ivf_trials' => 'required|integer|min:0|max:20',
            'known_causes_of_infertility' => 'nullable|string|max:255',
            'female_factor' => 'nullable|string|in:' . implode(",", FemaleFactorEnum::values()), // فرض شروط على قيمة العوامل الأنثوية
            'unexplained_infertility' => 'required|boolean',
            'report_female_factor' => 'nullable|string|max:100000',
            'report_male_factor' => 'nullable|string|max:100000',
            'report_other_factor' => 'nullable|string|max:100000', // عوامل غير معروفة
            'cycle_day' => 'required|integer|min:1|max:31',
            'date' => 'required|date|date_format:Y-m-d',
            'protocol' => 'nullable|string|in:' . implode(",", ProtocolTypeEnum::values()),
            'report_ultrasound' => 'nullable|string|max:100000',
            'report_laparoscopy' => 'nullable|string|max:100000',
            'report_hysteroscopy' => 'nullable|string|max:100000',
            "report_ultrasound_file" => "nullable|array",
            "report_laparoscopy_file" => "nullable|array",
            "report_hysteroscopy_file" => "nullable|array",
            "report_ultrasound_file.*" => "required|file|mimes:webm,mkv,flv,mp4,jpg,jpeg,png,pdf,doc,docs|max:" . $max,
            "report_laparoscopy_file.*" => "required|file|mimes:webm,mkv,flv,mp4,jpg,jpeg,png,pdf,doc,docs|max:" . $max,
            "report_hysteroscopy_file.*" => "required|file|mimes:webm,mkv,flv,mp4,jpg,jpeg,png,pdf,doc,docs|max:" . $max,
            "male_factor" => "nullable|array",
            "male_factor.*" => "required|string|in:" . implode(",", MaleFactorEnum::values()),
            "medications" => "nullable|array",

            "ovarian_stimulation" => "nullable|array",
            "ovarian_stimulation.*.medication_id" => "required_if:medications.*.medication_name,null|nullable|integer|exists:medications,id,type,ovarian_stimulation",
            "ovarian_stimulation.*.medication_name" => "required_if:medications.*.medication_id,null|nullable|string|max:255",
            "ovarian_stimulation.*.dose" => "required|string|max:255",
            "ovarian_stimulation.*.number_of_doses" => "required|integer",
            "ovarian_stimulation.*.report" => "nullable|string|max:100000",

            "ovulation_trigger" => "nullable|array",
            "ovulation_trigger.*.medication_id" => "required_if:medications.*.medication_name,null|nullable|integer|exists:medications,id,type,ovulation_trigger",
            "ovulation_trigger.*.medication_name" => "required_if:medications.*.medication_id,null|nullable|string|max:255",
            "ovulation_trigger.*.time" => "required|date_format:H:i",
            "ovulation_trigger.*.day" => "required|date|date_format:Y-m-d",
            "ovulation_trigger.*.report" => "nullable|string|max:100000",

        ];
    }

    public function messages(): array
    {
        return [
            // analysis_patient_id
            'analysis_patient_id.required' => __('validation.The analysis patient ID field is required'),
            'analysis_patient_id.integer' => __('validation.The analysis patient ID must be an integer'),
            'analysis_patient_id.exists' => __('validation.The selected analysis patient ID is invalid or does not match the type'),

            // duration_of_infertility
            'duration_of_infertility.required' => __('validation.The duration of infertility field is required'),
            'duration_of_infertility.integer' => __('validation.The duration of infertility must be an integer'),
            'duration_of_infertility.min' => __('validation.The duration of infertility must be at least :min'),
            'duration_of_infertility.max' => __('validation.The duration of infertility must not be greater than :max'),

            // number_of_children
            'number_of_children.required' => __('validation.The number of children field is required'),
            'number_of_children.integer' => __('validation.The number of children must be an integer'),
            'number_of_children.min' => __('validation.The number of children must be at least :min'),
            'number_of_children.max' => __('validation.The number of children must not be greater than :max'),

            // number_of_miscarriages
            'number_of_miscarriages.required' => __('validation.The number of miscarriages field is required'),
            'number_of_miscarriages.integer' => __('validation.The number of miscarriages must be an integer'),
            'number_of_miscarriages.min' => __('validation.The number of miscarriages must be at least :min'),
            'number_of_miscarriages.max' => __('validation.The number of miscarriages must not be greater than :max'),

            // previous_ivf_trials
            'previous_ivf_trials.required' => __('validation.The previous IVF trials field is required'),
            'previous_ivf_trials.integer' => __('validation.The previous IVF trials must be an integer'),
            'previous_ivf_trials.min' => __('validation.The previous IVF trials must be at least :min'),
            'previous_ivf_trials.max' => __('validation.The previous IVF trials must not be greater than :max'),

            // known_causes_of_infertility
            'known_causes_of_infertility.string' => __('validation.The known causes of infertility must be a string'),
            'known_causes_of_infertility.max' => __('validation.The known causes of infertility must not be greater than :max characters'),

            // female_factor
            'female_factor.string' => __('validation.The female factor must be a string'),
            'female_factor.in' => __('validation.The female factor must be one of the allowed values'),

            // unexplained_infertility
            'unexplained_infertility.required' => __('validation.The unexplained infertility field is required'),
            'unexplained_infertility.boolean' => __('validation.The unexplained infertility must be a boolean'),

            // report_female_factor
            'report_female_factor.string' => __('validation.The female factor report must be a string'),
            'report_female_factor.max' => __('validation.The female factor report must not be greater than :max characters'),

            // report_male_factor
            'report_male_factor.string' => __('validation.The male factor report must be a string'),
            'report_male_factor.max' => __('validation.The male factor report must not be greater than :max characters'),

            // report_other_factor
            'report_other_factor.string' => __('validation.The other factor report must be a string'),
            'report_other_factor.max' => __('validation.The other factor report must not be greater than :max characters'),

            // cycle_day
            'cycle_day.required' => __('validation.The cycle day field is required'),
            'cycle_day.integer' => __('validation.The cycle day must be an integer'),
            'cycle_day.min' => __('validation.The cycle day must be at least :min'),
            'cycle_day.max' => __('validation.The cycle day must not be greater than :max'),

            // date
            'date.required' => __('validation.The date field is required'),
            'date.date' => __('validation.The date must be a valid date'),
            'date.date_format' => __('validation.The date must be in the format Y-m-d'),

            // protocol
            'protocol.string' => __('validation.The protocol must be a string'),
            'protocol.in' => __('validation.The protocol must be one of the allowed values'),

            // report_ultrasound
            'report_ultrasound.string' => __('validation.The ultrasound report must be a string'),
            'report_ultrasound.max' => __('validation.The ultrasound report must not be greater than :max characters'),

            // report_laparoscopy
            'report_laparoscopy.string' => __('validation.The laparoscopy report must be a string'),
            'report_laparoscopy.max' => __('validation.The laparoscopy report must not be greater than :max characters'),

            // report_hysteroscopy
            'report_hysteroscopy.string' => __('validation.The hysteroscopy report must be a string'),
            'report_hysteroscopy.max' => __('validation.The hysteroscopy report must not be greater than :max characters'),

            // report_ultrasound_file
            'report_ultrasound_file.array' => __('validation.The ultrasound files must be an array'),
            'report_ultrasound_file.*.required' => __('validation.Each ultrasound file is required'),
            'report_ultrasound_file.*.file' => __('validation.Each ultrasound file must be a file'),
            'report_ultrasound_file.*.mimes' => __('validation.Each ultrasound file must be of type: webm, mkv, flv, mp4, jpg, jpeg, png, pdf, doc, docs'),
            'report_ultrasound_file.*.max' => __('validation.Each ultrasound file must not be greater than :max kilobytes'),

            // report_laparoscopy_file
            'report_laparoscopy_file.array' => __('validation.The laparoscopy files must be an array'),
            'report_laparoscopy_file.*.required' => __('validation.Each laparoscopy file is required'),
            'report_laparoscopy_file.*.file' => __('validation.Each laparoscopy file must be a file'),
            'report_laparoscopy_file.*.mimes' => __('validation.Each laparoscopy file must be of type: webm, mkv, flv, mp4, jpg, jpeg, png, pdf, doc, docs'),
            'report_laparoscopy_file.*.max' => __('validation.Each laparoscopy file must not be greater than :max kilobytes'),

            // report_hysteroscopy_file
            'report_hysteroscopy_file.array' => __('validation.The hysteroscopy files must be an array'),
            'report_hysteroscopy_file.*.required' => __('validation.Each hysteroscopy file is required'),
            'report_hysteroscopy_file.*.file' => __('validation.Each hysteroscopy file must be a file'),
            'report_hysteroscopy_file.*.mimes' => __('validation.Each hysteroscopy file must be of type: webm, mkv, flv, mp4, jpg, jpeg, png, pdf, doc, docs'),
            'report_hysteroscopy_file.*.max' => __('validation.Each hysteroscopy file must not be greater than :max kilobytes'),

            // male_factor
            'male_factor.array' => __('validation.The male factors must be an array'),
            'male_factor.*.required' => __('validation.Each male factor is required'),
            'male_factor.*.string' => __('validation.Each male factor must be a string'),
            'male_factor.*.in' => __('validation.Each male factor must be one of the allowed values'),

            // ovarian_stimulation
            'ovarian_stimulation.array' => __('validation.The ovarian stimulation data must be an array'),
            'ovarian_stimulation.*.medication_id.required_if' => __('validation.The medication ID is required when medication name is not provided'),
            'ovarian_stimulation.*.medication_id.integer' => __('validation.The medication ID must be an integer'),
            'ovarian_stimulation.*.medication_id.exists' => __('validation.The selected medication ID is invalid'),
            'ovarian_stimulation.*.medication_name.required_if' => __('validation.The medication name is required when medication ID is not provided'),
            'ovarian_stimulation.*.medication_name.string' => __('validation.The medication name must be a string'),
            'ovarian_stimulation.*.medication_name.max' => __('validation.The medication name must not be greater than :max characters'),
            'ovarian_stimulation.*.dose.required' => __('validation.The dose field is required'),
            'ovarian_stimulation.*.dose.string' => __('validation.The dose must be a string'),
            'ovarian_stimulation.*.dose.max' => __('validation.The dose must not be greater than :max characters'),
            'ovarian_stimulation.*.number_of_doses.required' => __('validation.The number of doses field is required'),
            'ovarian_stimulation.*.number_of_doses.integer' => __('validation.The number of doses must be an integer'),
            'ovarian_stimulation.*.report.string' => __('validation.The report must be a string'),
            'ovarian_stimulation.*.report.max' => __('validation.The report must not be greater than :max characters'),

            // ovulation_trigger
            'ovulation_trigger.array' => __('validation.The ovulation trigger data must be an array'),
            'ovulation_trigger.*.medication_id.required_if' => __('validation.The medication ID is required when medication name is not provided'),
            'ovulation_trigger.*.medication_id.integer' => __('validation.The medication ID must be an integer'),
            'ovulation_trigger.*.medication_id.exists' => __('validation.The selected medication ID is invalid'),
            'ovulation_trigger.*.medication_name.required_if' => __('validation.The medication name is required when medication ID is not provided'),
            'ovulation_trigger.*.medication_name.string' => __('validation.The medication name must be a string'),
            'ovulation_trigger.*.medication_name.max' => __('validation.The medication name must not be greater than :max characters'),
            'ovulation_trigger.*.time.required' => __('validation.The time field is required'),
            'ovulation_trigger.*.time.date_format' => __('validation.The time must be in the format H:i'),
            'ovulation_trigger.*.day.required' => __('validation.The day field is required'),
            'ovulation_trigger.*.day.date' => __('validation.The day must be a valid date'),
            'ovulation_trigger.*.day.date_format' => __('validation.The day must be in the format Y-m-d'),
            'ovulation_trigger.*.report.string' => __('validation.The report must be a string'),
            'ovulation_trigger.*.report.max' => __('validation.The report must not be greater than :max characters'),
        ];
    }
}
