<?php

namespace App\Http\Requests\Api;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use Illuminate\Foundation\Http\FormRequest;

class PregenantRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */

    /*
    public function authorize(): bool
    {
        return false;
    }*/

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
            //
            'patient_id' => 'required|integer|exists:patients,id',
            'action' => 'nullable|string|max:255',
        ];
    }

    public function messages(): array
    {
        return [
            // patient_id
            'patient_id.required' => __('validation.The patient ID field is required'),
            'patient_id.integer' => __('validation.The patient ID must be an integer'),
            'patient_id.exists' => __('validation.The selected patient ID is invalid'),

            // action
            'action.string' => __('validation.The action must be a string'),
            'action.max' => __('validation.The action must not be greater than :max characters'),
        ];
    }
}
