<?php

namespace App\Http\Requests\Api;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use App\Http\Helpers\HelperSetting;
use Illuminate\Foundation\Http\FormRequest;

class PgdRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */

    /*
    public function authorize(): bool
    {
        return false;
    }*/

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        $max =  HelperSetting::get_value('files_size_max_file_image') * 1024;

        return [
            //
            'patient_id' => 'required|integer|exists:patients,id',
            "analysis_patient_id" => "required|integer|exists:analysis_patients,id",
            'sample_date' => 'required|date|date_format:Y-m-d',
            'sample_date_day' => 'required|string|max:255',
            'report_date' => 'required|date|date_format:Y-m-d',
            'report_date_day' => 'required|string|max:255',
            'embyro.*' => 'required|array|min:1',
            'embyro.*.image' => 'required|image|mimes:jpeg,png,jpg|max:' . $max,
            'embyro.*.name' => 'required|string|max:255',
        ];
    }

    public function messages(): array
    {
        return [
            // patient_id
            'patient_id.required' => __('validation.The patient ID field is required'),
            'patient_id.integer' => __('validation.The patient ID must be an integer'),
            'patient_id.exists' => __('validation.The selected patient ID is invalid'),

            // analysis_patient_id
            'analysis_patient_id.required' => __('validation.The analysis patient ID field is required'),
            'analysis_patient_id.integer' => __('validation.The analysis patient ID must be an integer'),
            'analysis_patient_id.exists' => __('validation.The selected analysis patient ID is invalid'),

            // sample_date
            'sample_date.required' => __('validation.The sample date field is required'),
            'sample_date.date' => __('validation.The sample date must be a valid date'),
            'sample_date.date_format' => __('validation.The sample date must be in the format Y-m-d'),

            // sample_date_day
            'sample_date_day.required' => __('validation.The sample date day field is required'),
            'sample_date_day.string' => __('validation.The sample date day must be a string'),
            'sample_date_day.max' => __('validation.The sample date day must not be greater than :max characters'),

            // report_date
            'report_date.required' => __('validation.The report date field is required'),
            'report_date.date' => __('validation.The report date must be a valid date'),
            'report_date.date_format' => __('validation.The report date must be in the format Y-m-d'),

            // report_date_day
            'report_date_day.required' => __('validation.The report date day field is required'),
            'report_date_day.string' => __('validation.The report date day must be a string'),
            'report_date_day.max' => __('validation.The report date day must not be greater than :max characters'),

            // embyro.*
            'embyro.*.required' => __('validation.Each embryo field is required'),
            'embyro.*.array' => __('validation.Each embryo must be an array'),
            'embyro.*.min' => __('validation.Each embryo must have at least :min item'),

            // embyro.*.image
            'embyro.*.image.required' => __('validation.Each embryo image field is required'),
            'embyro.*.image.image' => __('validation.Each embryo image must be an image'),
            'embyro.*.image.mimes' => __('validation.Each embryo image must be of type: jpeg, png, jpg'),
            'embyro.*.image.max' => __('validation.Each embryo image must not be greater than :max kilobytes'),

            // embyro.*.name
            'embyro.*.name.required' => __('validation.Each embryo name field is required'),
            'embyro.*.name.string' => __('validation.Each embryo name must be a string'),
            'embyro.*.name.max' => __('validation.Each embryo name must not be greater than :max characters'),
        ];
    }
}
