<?php

namespace App\Http\Requests\Api;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/

use App\Http\Helpers\HelperSetting;
use Illuminate\Foundation\Http\FormRequest;

class PatientRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */

    /*
    public function authorize(): bool
    {
        return false;
    }*/

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        $max =  HelperSetting::get_value('files_size_max_file_image') * 1024;
        return [
            "gender" => "nullable|string|in:male,female",
            "name" => "required|string|max:255",
            "age" => "required|integer|min:10",
            "occupation" => "nullable|string|max:255",
            "height" => "required|numeric|min:100",
            "mobile" => "nullable|string|max:255",
            "place_of_residence" => "nullable|string|max:255",
            "id_number" => "nullable|numeric",
            "medical_file_number" => "nullable|numeric",
            "date_of_visit" => "required|date",
            "medical_history" => "nullable|string|max:100000",

            "other_name" => "required|string|max:255",
            "other_age" => "required|integer|min:10",
            "other_occupation" => "nullable|string|max:255",
            "other_height" => "required|numeric|min:100",
            "other_mobile" => "nullable|string|max:255",
            "other_place_of_residence" => "nullable|string|max:255",
            "other_id_number" => "nullable|numeric",
            "other_medical_file_number" => "nullable|numeric",
            "other_date_of_visit" => "required|date",
            "other_medical_history" => "nullable|string|max:100000",
            "attachments" => "nullable|array|max:5",
            "attachments.*" => "nullable|mimes:webm,mkv,flv,mp4,jpg,jpeg,png,pdf,doc,docs|max:" . $max,
            "other_attachments" => "nullable|array|max:5",
            "other_attachments.*" => "nullable|mimes:webm,mkv,flv,mp4,jpg,jpeg,png,pdf,doc,docs|max:" . $max,
            "date_marriage" => "required|date",




        ];
    }


    public function messages(): array
    {
        return [
            // gender
            'gender.string' => __('validation.The gender must be a string'),
            'gender.in' => __('validation.The gender must be either "male" or "female"'),

            // name
            'name.required' => __('validation.The name field is required'),
            'name.string' => __('validation.The name must be a string'),
            'name.max' => __('validation.The name must not be greater than :max characters'),

            // age
            'age.required' => __('validation.The age field is required'),
            'age.integer' => __('validation.The age must be an integer'),
            'age.min' => __('validation.The age must be at least :min'),

            // occupation
            'occupation.string' => __('validation.The occupation must be a string'),
            'occupation.max' => __('validation.The occupation must not be greater than :max characters'),

            // height
            'height.required' => __('validation.The height field is required'),
            'height.numeric' => __('validation.The height must be a number'),
            'height.min' => __('validation.The height must be at least :min'),

            // mobile
            'mobile.string' => __('validation.The mobile must be a string'),
            'mobile.max' => __('validation.The mobile must not be greater than :max characters'),

            // place_of_residence
            'place_of_residence.string' => __('validation.The place of residence must be a string'),
            'place_of_residence.max' => __('validation.The place of residence must not be greater than :max characters'),

            // id_number
            'id_number.numeric' => __('validation.The ID number must be a number'),

            // medical_file_number
            'medical_file_number.numeric' => __('validation.The medical file number must be a number'),

            // date_of_visit
            'date_of_visit.required' => __('validation.The date of visit field is required'),
            'date_of_visit.date' => __('validation.The date of visit must be a valid date'),

            // medical_history
            'medical_history.string' => __('validation.The medical history must be a string'),
            'medical_history.max' => __('validation.The medical history must not be greater than :max characters'),

            // other_name
            'other_name.required' => __('validation.The other name field is required'),
            'other_name.string' => __('validation.The other name must be a string'),
            'other_name.max' => __('validation.The other name must not be greater than :max characters'),

            // other_age
            'other_age.required' => __('validation.The other age field is required'),
            'other_age.integer' => __('validation.The other age must be an integer'),
            'other_age.min' => __('validation.The other age must be at least :min'),

            // other_occupation
            'other_occupation.string' => __('validation.The other occupation must be a string'),
            'other_occupation.max' => __('validation.The other occupation must not be greater than :max characters'),

            // other_height
            'other_height.required' => __('validation.The other height field is required'),
            'other_height.numeric' => __('validation.The other height must be a number'),
            'other_height.min' => __('validation.The other height must be at least :min'),

            // other_mobile
            'other_mobile.string' => __('validation.The other mobile must be a string'),
            'other_mobile.max' => __('validation.The other mobile must not be greater than :max characters'),

            // other_place_of_residence
            'other_place_of_residence.string' => __('validation.The other place of residence must be a string'),
            'other_place_of_residence.max' => __('validation.The other place of residence must not be greater than :max characters'),

            // other_id_number
            'other_id_number.numeric' => __('validation.The other ID number must be a number'),

            // other_medical_file_number
            'other_medical_file_number.numeric' => __('validation.The other medical file number must be a number'),

            // other_date_of_visit
            'other_date_of_visit.required' => __('validation.The other date of visit field is required'),
            'other_date_of_visit.date' => __('validation.The other date of visit must be a valid date'),

            // other_medical_history
            'other_medical_history.string' => __('validation.The other medical history must be a string'),
            'other_medical_history.max' => __('validation.The other medical history must not be greater than :max characters'),

            // attachments
            'attachments.array' => __('validation.The attachments must be an array'),
            'attachments.max' => __('validation.The attachments must not have more than :max files'),
            'attachments.*.mimes' => __('validation.Each attachment must be of type: webm, mkv, flv, mp4, jpg, jpeg, png, pdf, doc, docs'),
            'attachments.*.max' => __('validation.Each attachment must not be greater than :max kilobytes'),

            // other_attachments
            'other_attachments.array' => __('validation.The other attachments must be an array'),
            'other_attachments.max' => __('validation.The other attachments must not have more than :max files'),
            'other_attachments.*.mimes' => __('validation.Each other attachment must be of type: webm, mkv, flv, mp4, jpg, jpeg, png, pdf, doc, docs'),
            'other_attachments.*.max' => __('validation.Each other attachment must not be greater than :max kilobytes'),

            // date_marriage
            'date_marriage.required' => __('validation.The date of marriage field is required'),
            'date_marriage.date' => __('validation.The date of marriage must be a valid date'),
        ];
    }
}
