<?php

namespace App\Http\Requests\Api;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use Illuminate\Foundation\Http\FormRequest;

class LoginRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */

    /*
    public function authorize(): bool
    {
        return false;
    }*/

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
            // 'mobile_country_code'=>'required|string',
            // 'mobile'=>'required|string',
            "email"=>'required|email',
            'password'=>'required|string',
            "fcm_token"=>"required|string|max:255"
        ];
    }

    public function messages(): array
{
    return [
        // email
        'email.required' => __('validation.The email field is required'),
        'email.email' => __('validation.The email must be a valid email address'),

        // password
        'password.required' => __('validation.The password field is required'),
        'password.string' => __('validation.The password must be a string'),

        // fcm_token
        'fcm_token.required' => __('validation.The FCM token field is required'),
        'fcm_token.string' => __('validation.The FCM token must be a string'),
        'fcm_token.max' => __('validation.The FCM token must not be greater than :max characters'),
    ];
}
}
