<?php

namespace App\Http\Requests\Api;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/

use App\Enums\GeneticlabReportEnum;
use App\Http\Helpers\HelperSetting;
use Illuminate\Foundation\Http\FormRequest;

class GeneticLabRequestUpdate extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */

    /*
    public function authorize(): bool
    {
        return false;
    }*/

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        $types_report = GeneticlabReportEnum::values();
        $types_report = implode(",", $types_report);
        $max =  HelperSetting::get_value('files_size_max_file_image') * 1024;



        return [
            "id" => "required|integer|exists:genetic_labs,id",
            "patient_id" => "required|integer|exists:patients,id",
            "biopsy_day" => "required|integer|max:6|min:1",
            "biopsy_by" => "required|string|max:255",
            "witnessed_by" => "required|string|max:255",
            "biopsy_medium" => "required|string|max:255",
            "report" => "required|string|max:100000",
            "reports_fiels" => "nullable|array",
            "reports_fiels.*.type" => "required|distinct|in:" . $types_report,
            "reports_fiels.*.attachments" => "required|array",
            "reports_fiels.*.attachments.*" => "required|file|mimes:webm,mkv,flv,mp4,jpg,jpeg,png,pdf,doc,docs|max:" . $max,
        ];
    }


    public function messages(): array
{
    return [
        // id
        'id.required' => __('validation.The ID field is required'),
        'id.integer' => __('validation.The ID must be an integer'),
        'id.exists' => __('validation.The selected ID is invalid'),

        // patient_id
        'patient_id.required' => __('validation.The patient ID field is required'),
        'patient_id.integer' => __('validation.The patient ID must be an integer'),
        'patient_id.exists' => __('validation.The selected patient ID is invalid'),

        // biopsy_day
        'biopsy_day.required' => __('validation.The biopsy day field is required'),
        'biopsy_day.integer' => __('validation.The biopsy day must be an integer'),
        'biopsy_day.max' => __('validation.The biopsy day must not be greater than :max'),
        'biopsy_day.min' => __('validation.The biopsy day must be at least :min'),

        // biopsy_by
        'biopsy_by.required' => __('validation.The biopsy by field is required'),
        'biopsy_by.string' => __('validation.The biopsy by must be a string'),
        'biopsy_by.max' => __('validation.The biopsy by must not be greater than :max characters'),

        // witnessed_by
        'witnessed_by.required' => __('validation.The witnessed by field is required'),
        'witnessed_by.string' => __('validation.The witnessed by must be a string'),
        'witnessed_by.max' => __('validation.The witnessed by must not be greater than :max characters'),

        // biopsy_medium
        'biopsy_medium.required' => __('validation.The biopsy medium field is required'),
        'biopsy_medium.string' => __('validation.The biopsy medium must be a string'),
        'biopsy_medium.max' => __('validation.The biopsy medium must not be greater than :max characters'),

        // report
        'report.required' => __('validation.The report field is required'),
        'report.string' => __('validation.The report must be a string'),
        'report.max' => __('validation.The report must not be greater than :max characters'),

        // reports_fiels
        'reports_fiels.array' => __('validation.The reports fields must be an array'),

        // reports_fiels.*.type
        'reports_fiels.*.type.required' => __('validation.Each report type field is required'),
        'reports_fiels.*.type.distinct' => __('validation.Each report type must be unique'),
        'reports_fiels.*.type.in' => __('validation.Each report type must be one of the allowed values'),

        // reports_fiels.*.attachments
        'reports_fiels.*.attachments.required' => __('validation.Each report attachments field is required'),
        'reports_fiels.*.attachments.array' => __('validation.Each report attachments must be an array'),

        // reports_fiels.*.attachments.*
        'reports_fiels.*.attachments.*.required' => __('validation.Each attachment file is required'),
        'reports_fiels.*.attachments.*.file' => __('validation.Each attachment must be a file'),
        'reports_fiels.*.attachments.*.mimes' => __('validation.Each attachment must be of type: webm, mkv, flv, mp4, jpg, jpeg, png, pdf, doc, docs'),
        'reports_fiels.*.attachments.*.max' => __('validation.Each attachment must not be greater than :max kilobytes'),
    ];
}
}
