<?php

namespace App\Http\Requests\Api\Cryopreservation;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use Illuminate\Foundation\Http\FormRequest;

class ThawingRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */

    /*
    public function authorize(): bool
    {
        return false;
    }*/

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
            "patient_id"=>"required|integer|exists:patients,id",
            "oocyte_or_embryo"=>"required|string|in:oocyte,embryo",
            "number_oocyte_or_embryo"=>"required|integer",
            "day"=>"required|integer|min:1|max:6",
            "number_straw_or_straw_thawed"=>"required|integer",
            "number_straw_remaining"=>"required|integer",
            "degree"=>"required|string|max:100000",
            "report"=>"required|string|max:100000",
            "color_of_straw"=>"required|string|max:255",
            "media"=>"required|string|max:255",
            "date"=>"required|date",
        ];
    }

    public function messages(): array
{
    return [
        'patient_id.required' => __('validation.The patient ID field is required'),
        'patient_id.integer' => __('validation.The patient ID must be an integer'),
        'patient_id.exists' => __('validation.The selected patient ID is invalid'),

        'oocyte_or_embryo.required' => __('validation.The oocyte or embryo field is required'),
        'oocyte_or_embryo.string' => __('validation.The oocyte or embryo must be a string'),
        'oocyte_or_embryo.in' => __('validation.The oocyte or embryo must be either "oocyte" or "embryo"'),

        'number_oocyte_or_embryo.required' => __('validation.The number of oocyte or embryo field is required'),
        'number_oocyte_or_embryo.integer' => __('validation.The number of oocyte or embryo must be an integer'),

        'day.required' => __('validation.The day field is required'),
        'day.integer' => __('validation.The day must be an integer'),
        'day.min' => __('validation.The day must be at least :min', ['min' => 1]),
        'day.max' => __('validation.The day may not be greater than :max', ['max' => 6]),

        'number_straw_or_straw_thawed.required' => __('validation.The number of straw or straw thawed field is required'),
        'number_straw_or_straw_thawed.integer' => __('validation.The number of straw or straw thawed must be an integer'),

        'number_straw_remaining.required' => __('validation.The number of straw remaining field is required'),
        'number_straw_remaining.integer' => __('validation.The number of straw remaining must be an integer'),

        'degree.required' => __('validation.The degree field is required'),
        'degree.string' => __('validation.The degree must be a string'),
        'degree.max' => __('validation.The degree may not be greater than :max characters', ['max' => 100000]),

        'report.required' => __('validation.The report field is required'),
        'report.string' => __('validation.The report must be a string'),
        'report.max' => __('validation.The report may not be greater than :max characters', ['max' => 100000]),

        'color_of_straw.required' => __('validation.The color of straw field is required'),
        'color_of_straw.string' => __('validation.The color of straw must be a string'),
        'color_of_straw.max' => __('validation.The color of straw may not be greater than :max characters', ['max' => 255]),

        'media.required' => __('validation.The media field is required'),
        'media.string' => __('validation.The media must be a string'),
        'media.max' => __('validation.The media may not be greater than :max characters', ['max' => 255]),

        'date.required' => __('validation.The date field is required'),
        'date.date' => __('validation.The date must be a valid date'),
    ];
}
}
