<?php

namespace App\Http\Requests\Api\Cryopreservation;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use Illuminate\Foundation\Http\FormRequest;

class SpermRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */

    /*
    public function authorize(): bool
    {
        return false;
    }*/

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [


            "patient_id" => "required|integer|exists:patients,id",
            "count" => "required|integer",
            "abnormal_form" => "required|numeric|max:100",
            "frozen_sample_type" => "required|string|in:fna,tesa,tese,pesa,semen",
            "number_straw_or_straw_thawed" => "required|integer",
            "number_straw_remaining" => "required|integer",
            "report" => "required|string|max:100000",
            "date" => "required|date",
            "total_motility_progressive" => "required|numeric|max:100",
            "total_motility_non_progressive" => "required|numeric|max:100",
            "total_motility_immotile" => "required|numeric|max:100",
            "did_freezing" => "required|string|max:255",
            "media" => "required|string|max:255",


        ];
    }


    public function messages(): array
    {
        return [
            'patient_id.required' => __('validation.The patient ID field is required'),
            'patient_id.integer' => __('validation.The patient ID must be an integer'),
            'patient_id.exists' => __('validation.The selected patient ID is invalid'),

            'count.required' => __('validation.The count field is required'),
            'count.integer' => __('validation.The count must be an integer'),

            'abnormal_form.required' => __('validation.The abnormal form field is required'),
            'abnormal_form.numeric' => __('validation.The abnormal form must be a number'),
            'abnormal_form.max' => __('validation.The abnormal form may not be greater than :max', ['max' => 100]),

            'frozen_sample_type.required' => __('validation.The frozen sample type field is required'),
            'frozen_sample_type.string' => __('validation.The frozen sample type must be a string'),
            'frozen_sample_type.in' => __('validation.The frozen sample type must be one of the following: :values', ['values' => 'fna, tesa, tese, pesa, semen']),

            'number_straw_or_straw_thawed.required' => __('validation.The number of straw or straw thawed field is required'),
            'number_straw_or_straw_thawed.integer' => __('validation.The number of straw or straw thawed must be an integer'),

            'number_straw_remaining.required' => __('validation.The number of straw remaining field is required'),
            'number_straw_remaining.integer' => __('validation.The number of straw remaining must be an integer'),

            'report.required' => __('validation.The report field is required'),
            'report.string' => __('validation.The report must be a string'),
            'report.max' => __('validation.The report may not be greater than :max characters', ['max' => 100000]),

            'date.required' => __('validation.The date field is required'),
            'date.date' => __('validation.The date must be a valid date'),

            'total_motility_progressive.required' => __('validation.The total motility progressive field is required'),
            'total_motility_progressive.numeric' => __('validation.The total motility progressive must be a number'),
            'total_motility_progressive.max' => __('validation.The total motility progressive may not be greater than :max', ['max' => 100]),

            'total_motility_non_progressive.required' => __('validation.The total motility non progressive field is required'),
            'total_motility_non_progressive.numeric' => __('validation.The total motility non progressive must be a number'),
            'total_motility_non_progressive.max' => __('validation.The total motility non progressive may not be greater than :max', ['max' => 100]),

            'total_motility_immotile.required' => __('validation.The total motility immotile field is required'),
            'total_motility_immotile.numeric' => __('validation.The total motility immotile must be a number'),
            'total_motility_immotile.max' => __('validation.The total motility immotile may not be greater than :max', ['max' => 100]),

            'did_freezing.required' => __('validation.The did freezing field is required'),
            'did_freezing.string' => __('validation.The did freezing must be a string'),
            'did_freezing.max' => __('validation.The did freezing may not be greater than :max characters', ['max' => 255]),

            'media.required' => __('validation.The media field is required'),
            'media.string' => __('validation.The media must be a string'),
            'media.max' => __('validation.The media may not be greater than :max characters', ['max' => 255]),
        ];
    }
}
