<?php

namespace App\Http\Requests\Api;

/*

Done by Nofalseo Software Services
nofalseo.com \ info@nofalseo.com

*/


use Illuminate\Foundation\Http\FormRequest;

class AnalysisPatientRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */

    /*
    public function authorize(): bool
    {
        return false;
    }*/

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
            "type"=>"required|string|in:general,test_group",
            "patient_id"=>"required|integer|exists:patients,id",
            "doctor_name"=>"required_without:doctor_id|nullable|string|max:255",
            "doctor_id"=>"required_without:doctor_name|nullable|integer|exists:users,id",
            "general_analysis_id"=>"nullable|integer|exists:general_analyses,id,is_delete,0",
            "group_id"=>"nullable|integer|exists:group_general_analyses,id",
            "date"=>"required_if:type,test_group|nullable|date",
            "time"=>"required_if:type,test_group|nullable|date_format:H:i",
            "type_test_group_id"=>"required_if:type,test_group|nullable|integer|exists:type_test_groups,id"
        ];
    }

    public function messages(): array
{
    return [
        // type
        'type.required' => __('validation.The type field is required'),
        'type.string' => __('validation.The type must be a string'),
        'type.in' => __('validation.The type must be either "general" or "test_group"'),

        // patient_id
        'patient_id.required' => __('validation.The patient ID field is required'),
        'patient_id.integer' => __('validation.The patient ID must be an integer'),
        'patient_id.exists' => __('validation.The selected patient ID is invalid'),

        // doctor_name
        'doctor_name.required_without' => __('validation.The doctor name field is required when doctor ID is not present'),
        'doctor_name.string' => __('validation.The doctor name must be a string'),
        'doctor_name.max' => __('validation.The doctor name must not be greater than :max characters'),

        // doctor_id
        'doctor_id.required_without' => __('validation.The doctor ID field is required when doctor name is not present'),
        'doctor_id.integer' => __('validation.The doctor ID must be an integer'),
        'doctor_id.exists' => __('validation.The selected doctor ID is invalid'),

        // general_analysis_id
        'general_analysis_id.integer' => __('validation.The general analysis ID must be an integer'),
        'general_analysis_id.exists' => __('validation.The selected general analysis ID is invalid'),

        // group_id
        'group_id.integer' => __('validation.The group ID must be an integer'),
        'group_id.exists' => __('validation.The selected group ID is invalid'),

        // date
        'date.required_if' => __('validation.The date field is required when type is test group'),
        'date.date' => __('validation.The date must be a valid date'),

        // time
        'time.required_if' => __('validation.The time field is required when type is test group'),
        'time.date_format' => __('validation.The time must be in the format H:i'),

        // type_test_group_id
        'type_test_group_id.required_if' => __('validation.The type test group ID field is required when type is test group'),
        'type_test_group_id.integer' => __('validation.The type test group ID must be an integer'),
        'type_test_group_id.exists' => __('validation.The selected type test group ID is invalid'),
    ];
}
}
